# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re


class CarrierAddress(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        CarrierAddress - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'street_address1': 'str',
            'street_address2': 'str',
            'city': 'str',
            'state': 'str',
            'zipcode': 'str'
        }

        self.attribute_map = {
            'street_address1': 'streetAddress1',
            'street_address2': 'streetAddress2',
            'city': 'city',
            'state': 'state',
            'zipcode': 'zipcode'
        }

        self._street_address1 = None
        self._street_address2 = None
        self._city = None
        self._state = None
        self._zipcode = None

    @property
    def street_address1(self):
        """
        Gets the street_address1 of this CarrierAddress.


        :return: The street_address1 of this CarrierAddress.
        :rtype: str
        """
        return self._street_address1

    @street_address1.setter
    def street_address1(self, street_address1):
        """
        Sets the street_address1 of this CarrierAddress.


        :param street_address1: The street_address1 of this CarrierAddress.
        :type: str
        """
        
        self._street_address1 = street_address1

    @property
    def street_address2(self):
        """
        Gets the street_address2 of this CarrierAddress.


        :return: The street_address2 of this CarrierAddress.
        :rtype: str
        """
        return self._street_address2

    @street_address2.setter
    def street_address2(self, street_address2):
        """
        Sets the street_address2 of this CarrierAddress.


        :param street_address2: The street_address2 of this CarrierAddress.
        :type: str
        """
        
        self._street_address2 = street_address2

    @property
    def city(self):
        """
        Gets the city of this CarrierAddress.


        :return: The city of this CarrierAddress.
        :rtype: str
        """
        return self._city

    @city.setter
    def city(self, city):
        """
        Sets the city of this CarrierAddress.


        :param city: The city of this CarrierAddress.
        :type: str
        """
        
        self._city = city

    @property
    def state(self):
        """
        Gets the state of this CarrierAddress.


        :return: The state of this CarrierAddress.
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state):
        """
        Sets the state of this CarrierAddress.


        :param state: The state of this CarrierAddress.
        :type: str
        """
        
        self._state = state

    @property
    def zipcode(self):
        """
        Gets the zipcode of this CarrierAddress.


        :return: The zipcode of this CarrierAddress.
        :rtype: str
        """
        return self._zipcode

    @zipcode.setter
    def zipcode(self, zipcode):
        """
        Sets the zipcode of this CarrierAddress.


        :param zipcode: The zipcode of this CarrierAddress.
        :type: str
        """
        
        self._zipcode = zipcode

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

