# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re


class Charge(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        Charge - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'license_count': 'int',
            'name': 'str',
            'description': 'str',
            'price': 'float',
            'unit_of_measure': 'str',
            'billing_period': 'str',
            'quantity': 'int',
            'included_units': 'int'
        }

        self.attribute_map = {
            'license_count': 'licenseCount',
            'name': 'name',
            'description': 'description',
            'price': 'price',
            'unit_of_measure': 'unitOfMeasure',
            'billing_period': 'billingPeriod',
            'quantity': 'quantity',
            'included_units': 'includedUnits'
        }

        self._license_count = None
        self._name = None
        self._description = None
        self._price = None
        self._unit_of_measure = None
        self._billing_period = None
        self._quantity = None
        self._included_units = None

    @property
    def license_count(self):
        """
        Gets the license_count of this Charge.


        :return: The license_count of this Charge.
        :rtype: int
        """
        return self._license_count

    @license_count.setter
    def license_count(self, license_count):
        """
        Sets the license_count of this Charge.


        :param license_count: The license_count of this Charge.
        :type: int
        """
        
        self._license_count = license_count

    @property
    def name(self):
        """
        Gets the name of this Charge.


        :return: The name of this Charge.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this Charge.


        :param name: The name of this Charge.
        :type: str
        """
        
        self._name = name

    @property
    def description(self):
        """
        Gets the description of this Charge.


        :return: The description of this Charge.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this Charge.


        :param description: The description of this Charge.
        :type: str
        """
        
        self._description = description

    @property
    def price(self):
        """
        Gets the price of this Charge.


        :return: The price of this Charge.
        :rtype: float
        """
        return self._price

    @price.setter
    def price(self, price):
        """
        Sets the price of this Charge.


        :param price: The price of this Charge.
        :type: float
        """
        
        self._price = price

    @property
    def unit_of_measure(self):
        """
        Gets the unit_of_measure of this Charge.


        :return: The unit_of_measure of this Charge.
        :rtype: str
        """
        return self._unit_of_measure

    @unit_of_measure.setter
    def unit_of_measure(self, unit_of_measure):
        """
        Sets the unit_of_measure of this Charge.


        :param unit_of_measure: The unit_of_measure of this Charge.
        :type: str
        """
        
        self._unit_of_measure = unit_of_measure

    @property
    def billing_period(self):
        """
        Gets the billing_period of this Charge.


        :return: The billing_period of this Charge.
        :rtype: str
        """
        return self._billing_period

    @billing_period.setter
    def billing_period(self, billing_period):
        """
        Sets the billing_period of this Charge.


        :param billing_period: The billing_period of this Charge.
        :type: str
        """
        
        self._billing_period = billing_period

    @property
    def quantity(self):
        """
        Gets the quantity of this Charge.


        :return: The quantity of this Charge.
        :rtype: int
        """
        return self._quantity

    @quantity.setter
    def quantity(self, quantity):
        """
        Sets the quantity of this Charge.


        :param quantity: The quantity of this Charge.
        :type: int
        """
        
        self._quantity = quantity

    @property
    def included_units(self):
        """
        Gets the included_units of this Charge.


        :return: The included_units of this Charge.
        :rtype: int
        """
        return self._included_units

    @included_units.setter
    def included_units(self, included_units):
        """
        Sets the included_units of this Charge.


        :param included_units: The included_units of this Charge.
        :type: int
        """
        
        self._included_units = included_units

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

