# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re


class ClientSpreadsheetTransform(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        ClientSpreadsheetTransform - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'endpoint_id': 'str',
            'filename_replaces': 'list[BasicTransform]',
            'tags': 'list[TagModel]',
            'name': 'str',
            'sheet_name_replaces': 'list[IndexedTransform]',
            'sheets': 'list[SheetTransform]'
        }

        self.attribute_map = {
            'id': 'id',
            'endpoint_id': 'endpointId',
            'filename_replaces': 'filenameReplaces',
            'tags': 'tags',
            'name': 'name',
            'sheet_name_replaces': 'sheetNameReplaces',
            'sheets': 'sheets'
        }

        self._id = None
        self._endpoint_id = None
        self._filename_replaces = None
        self._tags = None
        self._name = None
        self._sheet_name_replaces = None
        self._sheets = None

    @property
    def id(self):
        """
        Gets the id of this ClientSpreadsheetTransform.


        :return: The id of this ClientSpreadsheetTransform.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this ClientSpreadsheetTransform.


        :param id: The id of this ClientSpreadsheetTransform.
        :type: str
        """
        
        self._id = id

    @property
    def endpoint_id(self):
        """
        Gets the endpoint_id of this ClientSpreadsheetTransform.


        :return: The endpoint_id of this ClientSpreadsheetTransform.
        :rtype: str
        """
        return self._endpoint_id

    @endpoint_id.setter
    def endpoint_id(self, endpoint_id):
        """
        Sets the endpoint_id of this ClientSpreadsheetTransform.


        :param endpoint_id: The endpoint_id of this ClientSpreadsheetTransform.
        :type: str
        """
        
        self._endpoint_id = endpoint_id

    @property
    def filename_replaces(self):
        """
        Gets the filename_replaces of this ClientSpreadsheetTransform.


        :return: The filename_replaces of this ClientSpreadsheetTransform.
        :rtype: list[BasicTransform]
        """
        return self._filename_replaces

    @filename_replaces.setter
    def filename_replaces(self, filename_replaces):
        """
        Sets the filename_replaces of this ClientSpreadsheetTransform.


        :param filename_replaces: The filename_replaces of this ClientSpreadsheetTransform.
        :type: list[BasicTransform]
        """
        
        self._filename_replaces = filename_replaces

    @property
    def tags(self):
        """
        Gets the tags of this ClientSpreadsheetTransform.


        :return: The tags of this ClientSpreadsheetTransform.
        :rtype: list[TagModel]
        """
        return self._tags

    @tags.setter
    def tags(self, tags):
        """
        Sets the tags of this ClientSpreadsheetTransform.


        :param tags: The tags of this ClientSpreadsheetTransform.
        :type: list[TagModel]
        """
        
        self._tags = tags

    @property
    def name(self):
        """
        Gets the name of this ClientSpreadsheetTransform.


        :return: The name of this ClientSpreadsheetTransform.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this ClientSpreadsheetTransform.


        :param name: The name of this ClientSpreadsheetTransform.
        :type: str
        """
        
        self._name = name

    @property
    def sheet_name_replaces(self):
        """
        Gets the sheet_name_replaces of this ClientSpreadsheetTransform.


        :return: The sheet_name_replaces of this ClientSpreadsheetTransform.
        :rtype: list[IndexedTransform]
        """
        return self._sheet_name_replaces

    @sheet_name_replaces.setter
    def sheet_name_replaces(self, sheet_name_replaces):
        """
        Sets the sheet_name_replaces of this ClientSpreadsheetTransform.


        :param sheet_name_replaces: The sheet_name_replaces of this ClientSpreadsheetTransform.
        :type: list[IndexedTransform]
        """
        
        self._sheet_name_replaces = sheet_name_replaces

    @property
    def sheets(self):
        """
        Gets the sheets of this ClientSpreadsheetTransform.


        :return: The sheets of this ClientSpreadsheetTransform.
        :rtype: list[SheetTransform]
        """
        return self._sheets

    @sheets.setter
    def sheets(self, sheets):
        """
        Sets the sheets of this ClientSpreadsheetTransform.


        :param sheets: The sheets of this ClientSpreadsheetTransform.
        :type: list[SheetTransform]
        """
        
        self._sheets = sheets

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

