# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re


class ComposerTemplate(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        ComposerTemplate - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'description': 'str',
            'created_date': 'datetime',
            'modified_date': 'datetime',
            'version': 'int',
            'level': 'str',
            'tags': 'list[str]',
            'data': 'dict(str, object)',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'description': 'description',
            'created_date': 'createdDate',
            'modified_date': 'modifiedDate',
            'version': 'version',
            'level': 'level',
            'tags': 'tags',
            'data': 'data',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._name = None
        self._description = None
        self._created_date = None
        self._modified_date = None
        self._version = None
        self._level = None
        self._tags = None
        self._data = None
        self._self_uri = None

    @property
    def id(self):
        """
        Gets the id of this ComposerTemplate.
        The globally unique identifier for the object.

        :return: The id of this ComposerTemplate.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this ComposerTemplate.
        The globally unique identifier for the object.

        :param id: The id of this ComposerTemplate.
        :type: str
        """
        
        self._id = id

    @property
    def name(self):
        """
        Gets the name of this ComposerTemplate.


        :return: The name of this ComposerTemplate.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this ComposerTemplate.


        :param name: The name of this ComposerTemplate.
        :type: str
        """
        
        self._name = name

    @property
    def description(self):
        """
        Gets the description of this ComposerTemplate.


        :return: The description of this ComposerTemplate.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this ComposerTemplate.


        :param description: The description of this ComposerTemplate.
        :type: str
        """
        
        self._description = description

    @property
    def created_date(self):
        """
        Gets the created_date of this ComposerTemplate.
        Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :return: The created_date of this ComposerTemplate.
        :rtype: datetime
        """
        return self._created_date

    @created_date.setter
    def created_date(self, created_date):
        """
        Sets the created_date of this ComposerTemplate.
        Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :param created_date: The created_date of this ComposerTemplate.
        :type: datetime
        """
        
        self._created_date = created_date

    @property
    def modified_date(self):
        """
        Gets the modified_date of this ComposerTemplate.
        Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :return: The modified_date of this ComposerTemplate.
        :rtype: datetime
        """
        return self._modified_date

    @modified_date.setter
    def modified_date(self, modified_date):
        """
        Sets the modified_date of this ComposerTemplate.
        Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :param modified_date: The modified_date of this ComposerTemplate.
        :type: datetime
        """
        
        self._modified_date = modified_date

    @property
    def version(self):
        """
        Gets the version of this ComposerTemplate.


        :return: The version of this ComposerTemplate.
        :rtype: int
        """
        return self._version

    @version.setter
    def version(self, version):
        """
        Sets the version of this ComposerTemplate.


        :param version: The version of this ComposerTemplate.
        :type: int
        """
        
        self._version = version

    @property
    def level(self):
        """
        Gets the level of this ComposerTemplate.


        :return: The level of this ComposerTemplate.
        :rtype: str
        """
        return self._level

    @level.setter
    def level(self, level):
        """
        Sets the level of this ComposerTemplate.


        :param level: The level of this ComposerTemplate.
        :type: str
        """
        allowed_values = ["GLOBAL", "ORGANIZATION", "USER"]
        if level not in allowed_values:
            raise ValueError(
                "Invalid value for `level`, must be one of {0}"
                .format(allowed_values)
            )

        self._level = level

    @property
    def tags(self):
        """
        Gets the tags of this ComposerTemplate.


        :return: The tags of this ComposerTemplate.
        :rtype: list[str]
        """
        return self._tags

    @tags.setter
    def tags(self, tags):
        """
        Sets the tags of this ComposerTemplate.


        :param tags: The tags of this ComposerTemplate.
        :type: list[str]
        """
        
        self._tags = tags

    @property
    def data(self):
        """
        Gets the data of this ComposerTemplate.


        :return: The data of this ComposerTemplate.
        :rtype: dict(str, object)
        """
        return self._data

    @data.setter
    def data(self, data):
        """
        Sets the data of this ComposerTemplate.


        :param data: The data of this ComposerTemplate.
        :type: dict(str, object)
        """
        
        self._data = data

    @property
    def self_uri(self):
        """
        Gets the self_uri of this ComposerTemplate.
        The URI for this object

        :return: The self_uri of this ComposerTemplate.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri):
        """
        Sets the self_uri of this ComposerTemplate.
        The URI for this object

        :param self_uri: The self_uri of this ComposerTemplate.
        :type: str
        """
        
        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

