# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re


class ContactList(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        ContactList - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'date_created': 'datetime',
            'date_modified': 'datetime',
            'version': 'int',
            'column_names': 'list[str]',
            'phone_columns': 'list[ContactPhoneNumberColumn]',
            'import_status': 'ImportStatus',
            'preview_mode_column_name': 'str',
            'preview_mode_accepted_values': 'list[str]',
            'size': 'int',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'date_created': 'dateCreated',
            'date_modified': 'dateModified',
            'version': 'version',
            'column_names': 'columnNames',
            'phone_columns': 'phoneColumns',
            'import_status': 'importStatus',
            'preview_mode_column_name': 'previewModeColumnName',
            'preview_mode_accepted_values': 'previewModeAcceptedValues',
            'size': 'size',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._name = None
        self._date_created = None
        self._date_modified = None
        self._version = None
        self._column_names = None
        self._phone_columns = None
        self._import_status = None
        self._preview_mode_column_name = None
        self._preview_mode_accepted_values = None
        self._size = None
        self._self_uri = None

    @property
    def id(self):
        """
        Gets the id of this ContactList.
        The globally unique identifier for the object.

        :return: The id of this ContactList.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this ContactList.
        The globally unique identifier for the object.

        :param id: The id of this ContactList.
        :type: str
        """
        
        self._id = id

    @property
    def name(self):
        """
        Gets the name of this ContactList.


        :return: The name of this ContactList.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this ContactList.


        :param name: The name of this ContactList.
        :type: str
        """
        
        self._name = name

    @property
    def date_created(self):
        """
        Gets the date_created of this ContactList.
        Creation time of the entity. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :return: The date_created of this ContactList.
        :rtype: datetime
        """
        return self._date_created

    @date_created.setter
    def date_created(self, date_created):
        """
        Sets the date_created of this ContactList.
        Creation time of the entity. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :param date_created: The date_created of this ContactList.
        :type: datetime
        """
        
        self._date_created = date_created

    @property
    def date_modified(self):
        """
        Gets the date_modified of this ContactList.
        Last modified time of the entity. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :return: The date_modified of this ContactList.
        :rtype: datetime
        """
        return self._date_modified

    @date_modified.setter
    def date_modified(self, date_modified):
        """
        Sets the date_modified of this ContactList.
        Last modified time of the entity. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :param date_modified: The date_modified of this ContactList.
        :type: datetime
        """
        
        self._date_modified = date_modified

    @property
    def version(self):
        """
        Gets the version of this ContactList.
        Required for updates, must match the version number of the most recent update

        :return: The version of this ContactList.
        :rtype: int
        """
        return self._version

    @version.setter
    def version(self, version):
        """
        Sets the version of this ContactList.
        Required for updates, must match the version number of the most recent update

        :param version: The version of this ContactList.
        :type: int
        """
        
        self._version = version

    @property
    def column_names(self):
        """
        Gets the column_names of this ContactList.
        the contact column names

        :return: The column_names of this ContactList.
        :rtype: list[str]
        """
        return self._column_names

    @column_names.setter
    def column_names(self, column_names):
        """
        Sets the column_names of this ContactList.
        the contact column names

        :param column_names: The column_names of this ContactList.
        :type: list[str]
        """
        
        self._column_names = column_names

    @property
    def phone_columns(self):
        """
        Gets the phone_columns of this ContactList.
        the columns containing phone numbers

        :return: The phone_columns of this ContactList.
        :rtype: list[ContactPhoneNumberColumn]
        """
        return self._phone_columns

    @phone_columns.setter
    def phone_columns(self, phone_columns):
        """
        Sets the phone_columns of this ContactList.
        the columns containing phone numbers

        :param phone_columns: The phone_columns of this ContactList.
        :type: list[ContactPhoneNumberColumn]
        """
        
        self._phone_columns = phone_columns

    @property
    def import_status(self):
        """
        Gets the import_status of this ContactList.
        the status of the import process

        :return: The import_status of this ContactList.
        :rtype: ImportStatus
        """
        return self._import_status

    @import_status.setter
    def import_status(self, import_status):
        """
        Sets the import_status of this ContactList.
        the status of the import process

        :param import_status: The import_status of this ContactList.
        :type: ImportStatus
        """
        
        self._import_status = import_status

    @property
    def preview_mode_column_name(self):
        """
        Gets the preview_mode_column_name of this ContactList.
        the name of the column that holds the indicators for contacts that are to be dialed in preview mode only

        :return: The preview_mode_column_name of this ContactList.
        :rtype: str
        """
        return self._preview_mode_column_name

    @preview_mode_column_name.setter
    def preview_mode_column_name(self, preview_mode_column_name):
        """
        Sets the preview_mode_column_name of this ContactList.
        the name of the column that holds the indicators for contacts that are to be dialed in preview mode only

        :param preview_mode_column_name: The preview_mode_column_name of this ContactList.
        :type: str
        """
        
        self._preview_mode_column_name = preview_mode_column_name

    @property
    def preview_mode_accepted_values(self):
        """
        Gets the preview_mode_accepted_values of this ContactList.
        list of user-defined values indicating the contact is to be dialed in preview mode only

        :return: The preview_mode_accepted_values of this ContactList.
        :rtype: list[str]
        """
        return self._preview_mode_accepted_values

    @preview_mode_accepted_values.setter
    def preview_mode_accepted_values(self, preview_mode_accepted_values):
        """
        Sets the preview_mode_accepted_values of this ContactList.
        list of user-defined values indicating the contact is to be dialed in preview mode only

        :param preview_mode_accepted_values: The preview_mode_accepted_values of this ContactList.
        :type: list[str]
        """
        
        self._preview_mode_accepted_values = preview_mode_accepted_values

    @property
    def size(self):
        """
        Gets the size of this ContactList.
        the number of contacts in the contact list

        :return: The size of this ContactList.
        :rtype: int
        """
        return self._size

    @size.setter
    def size(self, size):
        """
        Sets the size of this ContactList.
        the number of contacts in the contact list

        :param size: The size of this ContactList.
        :type: int
        """
        
        self._size = size

    @property
    def self_uri(self):
        """
        Gets the self_uri of this ContactList.
        The URI for this object

        :return: The self_uri of this ContactList.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri):
        """
        Sets the self_uri of this ContactList.
        The URI for this object

        :param self_uri: The self_uri of this ContactList.
        :type: str
        """
        
        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

