# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re


class ContactSales(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        ContactSales - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'email': 'str',
            'first_name': 'str',
            'last_name': 'str',
            'contact_phone': 'str',
            'country': 'str',
            'title': 'str',
            'message': 'str',
            'language': 'str',
            'product_name': 'str',
            'quote_id': 'str',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'email': 'email',
            'first_name': 'firstName',
            'last_name': 'lastName',
            'contact_phone': 'contactPhone',
            'country': 'country',
            'title': 'title',
            'message': 'message',
            'language': 'language',
            'product_name': 'productName',
            'quote_id': 'quoteId',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._name = None
        self._email = None
        self._first_name = None
        self._last_name = None
        self._contact_phone = None
        self._country = None
        self._title = None
        self._message = None
        self._language = None
        self._product_name = None
        self._quote_id = None
        self._self_uri = None

    @property
    def id(self):
        """
        Gets the id of this ContactSales.
        The globally unique identifier for the object.

        :return: The id of this ContactSales.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this ContactSales.
        The globally unique identifier for the object.

        :param id: The id of this ContactSales.
        :type: str
        """
        
        self._id = id

    @property
    def name(self):
        """
        Gets the name of this ContactSales.


        :return: The name of this ContactSales.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this ContactSales.


        :param name: The name of this ContactSales.
        :type: str
        """
        
        self._name = name

    @property
    def email(self):
        """
        Gets the email of this ContactSales.


        :return: The email of this ContactSales.
        :rtype: str
        """
        return self._email

    @email.setter
    def email(self, email):
        """
        Sets the email of this ContactSales.


        :param email: The email of this ContactSales.
        :type: str
        """
        
        self._email = email

    @property
    def first_name(self):
        """
        Gets the first_name of this ContactSales.


        :return: The first_name of this ContactSales.
        :rtype: str
        """
        return self._first_name

    @first_name.setter
    def first_name(self, first_name):
        """
        Sets the first_name of this ContactSales.


        :param first_name: The first_name of this ContactSales.
        :type: str
        """
        
        self._first_name = first_name

    @property
    def last_name(self):
        """
        Gets the last_name of this ContactSales.


        :return: The last_name of this ContactSales.
        :rtype: str
        """
        return self._last_name

    @last_name.setter
    def last_name(self, last_name):
        """
        Sets the last_name of this ContactSales.


        :param last_name: The last_name of this ContactSales.
        :type: str
        """
        
        self._last_name = last_name

    @property
    def contact_phone(self):
        """
        Gets the contact_phone of this ContactSales.


        :return: The contact_phone of this ContactSales.
        :rtype: str
        """
        return self._contact_phone

    @contact_phone.setter
    def contact_phone(self, contact_phone):
        """
        Sets the contact_phone of this ContactSales.


        :param contact_phone: The contact_phone of this ContactSales.
        :type: str
        """
        
        self._contact_phone = contact_phone

    @property
    def country(self):
        """
        Gets the country of this ContactSales.


        :return: The country of this ContactSales.
        :rtype: str
        """
        return self._country

    @country.setter
    def country(self, country):
        """
        Sets the country of this ContactSales.


        :param country: The country of this ContactSales.
        :type: str
        """
        
        self._country = country

    @property
    def title(self):
        """
        Gets the title of this ContactSales.


        :return: The title of this ContactSales.
        :rtype: str
        """
        return self._title

    @title.setter
    def title(self, title):
        """
        Sets the title of this ContactSales.


        :param title: The title of this ContactSales.
        :type: str
        """
        
        self._title = title

    @property
    def message(self):
        """
        Gets the message of this ContactSales.


        :return: The message of this ContactSales.
        :rtype: str
        """
        return self._message

    @message.setter
    def message(self, message):
        """
        Sets the message of this ContactSales.


        :param message: The message of this ContactSales.
        :type: str
        """
        
        self._message = message

    @property
    def language(self):
        """
        Gets the language of this ContactSales.


        :return: The language of this ContactSales.
        :rtype: str
        """
        return self._language

    @language.setter
    def language(self, language):
        """
        Sets the language of this ContactSales.


        :param language: The language of this ContactSales.
        :type: str
        """
        
        self._language = language

    @property
    def product_name(self):
        """
        Gets the product_name of this ContactSales.


        :return: The product_name of this ContactSales.
        :rtype: str
        """
        return self._product_name

    @product_name.setter
    def product_name(self, product_name):
        """
        Sets the product_name of this ContactSales.


        :param product_name: The product_name of this ContactSales.
        :type: str
        """
        
        self._product_name = product_name

    @property
    def quote_id(self):
        """
        Gets the quote_id of this ContactSales.


        :return: The quote_id of this ContactSales.
        :rtype: str
        """
        return self._quote_id

    @quote_id.setter
    def quote_id(self, quote_id):
        """
        Sets the quote_id of this ContactSales.


        :param quote_id: The quote_id of this ContactSales.
        :type: str
        """
        
        self._quote_id = quote_id

    @property
    def self_uri(self):
        """
        Gets the self_uri of this ContactSales.
        The URI for this object

        :return: The self_uri of this ContactSales.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri):
        """
        Sets the self_uri of this ContactSales.
        The URI for this object

        :param self_uri: The self_uri of this ContactSales.
        :type: str
        """
        
        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

