# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re


class Contract(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        Contract - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'quote': 'Quote',
            'signer_url': 'str',
            'job': 'ContractJob',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'quote': 'quote',
            'signer_url': 'signerUrl',
            'job': 'job',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._name = None
        self._quote = None
        self._signer_url = None
        self._job = None
        self._self_uri = None

    @property
    def id(self):
        """
        Gets the id of this Contract.
        The globally unique identifier for the object.

        :return: The id of this Contract.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this Contract.
        The globally unique identifier for the object.

        :param id: The id of this Contract.
        :type: str
        """
        
        self._id = id

    @property
    def name(self):
        """
        Gets the name of this Contract.


        :return: The name of this Contract.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this Contract.


        :param name: The name of this Contract.
        :type: str
        """
        
        self._name = name

    @property
    def quote(self):
        """
        Gets the quote of this Contract.


        :return: The quote of this Contract.
        :rtype: Quote
        """
        return self._quote

    @quote.setter
    def quote(self, quote):
        """
        Sets the quote of this Contract.


        :param quote: The quote of this Contract.
        :type: Quote
        """
        
        self._quote = quote

    @property
    def signer_url(self):
        """
        Gets the signer_url of this Contract.


        :return: The signer_url of this Contract.
        :rtype: str
        """
        return self._signer_url

    @signer_url.setter
    def signer_url(self, signer_url):
        """
        Sets the signer_url of this Contract.


        :param signer_url: The signer_url of this Contract.
        :type: str
        """
        
        self._signer_url = signer_url

    @property
    def job(self):
        """
        Gets the job of this Contract.


        :return: The job of this Contract.
        :rtype: ContractJob
        """
        return self._job

    @job.setter
    def job(self, job):
        """
        Sets the job of this Contract.


        :param job: The job of this Contract.
        :type: ContractJob
        """
        
        self._job = job

    @property
    def self_uri(self):
        """
        Gets the self_uri of this Contract.
        The URI for this object

        :return: The self_uri of this Contract.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri):
        """
        Sets the self_uri of this Contract.
        The URI for this object

        :param self_uri: The self_uri of this Contract.
        :type: str
        """
        
        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

