# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re


class ContractJob(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        ContractJob - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'contract': 'Contract',
            'status': 'str',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'contract': 'contract',
            'status': 'status',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._name = None
        self._contract = None
        self._status = None
        self._self_uri = None

    @property
    def id(self):
        """
        Gets the id of this ContractJob.
        The globally unique identifier for the object.

        :return: The id of this ContractJob.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this ContractJob.
        The globally unique identifier for the object.

        :param id: The id of this ContractJob.
        :type: str
        """
        
        self._id = id

    @property
    def name(self):
        """
        Gets the name of this ContractJob.


        :return: The name of this ContractJob.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this ContractJob.


        :param name: The name of this ContractJob.
        :type: str
        """
        
        self._name = name

    @property
    def contract(self):
        """
        Gets the contract of this ContractJob.


        :return: The contract of this ContractJob.
        :rtype: Contract
        """
        return self._contract

    @contract.setter
    def contract(self, contract):
        """
        Sets the contract of this ContractJob.


        :param contract: The contract of this ContractJob.
        :type: Contract
        """
        
        self._contract = contract

    @property
    def status(self):
        """
        Gets the status of this ContractJob.
        The current status of the job.

        :return: The status of this ContractJob.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """
        Sets the status of this ContractJob.
        The current status of the job.

        :param status: The status of this ContractJob.
        :type: str
        """
        allowed_values = ["Processing", "Completed", "Failed"]
        if status not in allowed_values:
            raise ValueError(
                "Invalid value for `status`, must be one of {0}"
                .format(allowed_values)
            )

        self._status = status

    @property
    def self_uri(self):
        """
        Gets the self_uri of this ContractJob.
        The URI for this object

        :return: The self_uri of this ContractJob.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri):
        """
        Sets the self_uri of this ContractJob.
        The URI for this object

        :param self_uri: The self_uri of this ContractJob.
        :type: str
        """
        
        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

