# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re


class Control(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        Control - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'label': 'str',
            'options': 'list[ControlOptions]',
            'required': 'bool',
            'read_only': 'bool',
            'variable_binding_id': 'str',
            'type': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'label': 'label',
            'options': 'options',
            'required': 'required',
            'read_only': 'readOnly',
            'variable_binding_id': 'variableBindingId',
            'type': 'type'
        }

        self._id = None
        self._label = None
        self._options = None
        self._required = False
        self._read_only = False
        self._variable_binding_id = None
        self._type = None

    @property
    def id(self):
        """
        Gets the id of this Control.


        :return: The id of this Control.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this Control.


        :param id: The id of this Control.
        :type: str
        """
        
        self._id = id

    @property
    def label(self):
        """
        Gets the label of this Control.


        :return: The label of this Control.
        :rtype: str
        """
        return self._label

    @label.setter
    def label(self, label):
        """
        Sets the label of this Control.


        :param label: The label of this Control.
        :type: str
        """
        
        self._label = label

    @property
    def options(self):
        """
        Gets the options of this Control.


        :return: The options of this Control.
        :rtype: list[ControlOptions]
        """
        return self._options

    @options.setter
    def options(self, options):
        """
        Sets the options of this Control.


        :param options: The options of this Control.
        :type: list[ControlOptions]
        """
        
        self._options = options

    @property
    def required(self):
        """
        Gets the required of this Control.


        :return: The required of this Control.
        :rtype: bool
        """
        return self._required

    @required.setter
    def required(self, required):
        """
        Sets the required of this Control.


        :param required: The required of this Control.
        :type: bool
        """
        
        self._required = required

    @property
    def read_only(self):
        """
        Gets the read_only of this Control.


        :return: The read_only of this Control.
        :rtype: bool
        """
        return self._read_only

    @read_only.setter
    def read_only(self, read_only):
        """
        Sets the read_only of this Control.


        :param read_only: The read_only of this Control.
        :type: bool
        """
        
        self._read_only = read_only

    @property
    def variable_binding_id(self):
        """
        Gets the variable_binding_id of this Control.


        :return: The variable_binding_id of this Control.
        :rtype: str
        """
        return self._variable_binding_id

    @variable_binding_id.setter
    def variable_binding_id(self, variable_binding_id):
        """
        Sets the variable_binding_id of this Control.


        :param variable_binding_id: The variable_binding_id of this Control.
        :type: str
        """
        
        self._variable_binding_id = variable_binding_id

    @property
    def type(self):
        """
        Gets the type of this Control.


        :return: The type of this Control.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this Control.


        :param type: The type of this Control.
        :type: str
        """
        allowed_values = ["CHECKBOX", "RADIO", "SELECT"]
        if type not in allowed_values:
            raise ValueError(
                "Invalid value for `type`, must be one of {0}"
                .format(allowed_values)
            )

        self._type = type

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

