# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re


class ConversationChat(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        ConversationChat - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'state': 'str',
            'id': 'str',
            'room_id': 'str',
            'recording_id': 'str',
            'segments': 'list[Segment]',
            'held': 'bool',
            'direction': 'str',
            'disconnect_type': 'str',
            'start_hold_time': 'datetime',
            'connected_time': 'datetime',
            'disconnected_time': 'datetime'
        }

        self.attribute_map = {
            'state': 'state',
            'id': 'id',
            'room_id': 'roomId',
            'recording_id': 'recordingId',
            'segments': 'segments',
            'held': 'held',
            'direction': 'direction',
            'disconnect_type': 'disconnectType',
            'start_hold_time': 'startHoldTime',
            'connected_time': 'connectedTime',
            'disconnected_time': 'disconnectedTime'
        }

        self._state = None
        self._id = None
        self._room_id = None
        self._recording_id = None
        self._segments = None
        self._held = False
        self._direction = None
        self._disconnect_type = None
        self._start_hold_time = None
        self._connected_time = None
        self._disconnected_time = None

    @property
    def state(self):
        """
        Gets the state of this ConversationChat.


        :return: The state of this ConversationChat.
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state):
        """
        Sets the state of this ConversationChat.


        :param state: The state of this ConversationChat.
        :type: str
        """
        allowed_values = ["ALERTING", "DIALING", "CONTACTING", "OFFERING", "CONNECTED", "DISCONNECTED", "TERMINATED", "NONE"]
        if state not in allowed_values:
            raise ValueError(
                "Invalid value for `state`, must be one of {0}"
                .format(allowed_values)
            )

        self._state = state

    @property
    def id(self):
        """
        Gets the id of this ConversationChat.


        :return: The id of this ConversationChat.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this ConversationChat.


        :param id: The id of this ConversationChat.
        :type: str
        """
        
        self._id = id

    @property
    def room_id(self):
        """
        Gets the room_id of this ConversationChat.


        :return: The room_id of this ConversationChat.
        :rtype: str
        """
        return self._room_id

    @room_id.setter
    def room_id(self, room_id):
        """
        Sets the room_id of this ConversationChat.


        :param room_id: The room_id of this ConversationChat.
        :type: str
        """
        
        self._room_id = room_id

    @property
    def recording_id(self):
        """
        Gets the recording_id of this ConversationChat.


        :return: The recording_id of this ConversationChat.
        :rtype: str
        """
        return self._recording_id

    @recording_id.setter
    def recording_id(self, recording_id):
        """
        Sets the recording_id of this ConversationChat.


        :param recording_id: The recording_id of this ConversationChat.
        :type: str
        """
        
        self._recording_id = recording_id

    @property
    def segments(self):
        """
        Gets the segments of this ConversationChat.


        :return: The segments of this ConversationChat.
        :rtype: list[Segment]
        """
        return self._segments

    @segments.setter
    def segments(self, segments):
        """
        Sets the segments of this ConversationChat.


        :param segments: The segments of this ConversationChat.
        :type: list[Segment]
        """
        
        self._segments = segments

    @property
    def held(self):
        """
        Gets the held of this ConversationChat.


        :return: The held of this ConversationChat.
        :rtype: bool
        """
        return self._held

    @held.setter
    def held(self, held):
        """
        Sets the held of this ConversationChat.


        :param held: The held of this ConversationChat.
        :type: bool
        """
        
        self._held = held

    @property
    def direction(self):
        """
        Gets the direction of this ConversationChat.


        :return: The direction of this ConversationChat.
        :rtype: str
        """
        return self._direction

    @direction.setter
    def direction(self, direction):
        """
        Sets the direction of this ConversationChat.


        :param direction: The direction of this ConversationChat.
        :type: str
        """
        allowed_values = ["INBOUND", "OUTBOUND"]
        if direction not in allowed_values:
            raise ValueError(
                "Invalid value for `direction`, must be one of {0}"
                .format(allowed_values)
            )

        self._direction = direction

    @property
    def disconnect_type(self):
        """
        Gets the disconnect_type of this ConversationChat.


        :return: The disconnect_type of this ConversationChat.
        :rtype: str
        """
        return self._disconnect_type

    @disconnect_type.setter
    def disconnect_type(self, disconnect_type):
        """
        Sets the disconnect_type of this ConversationChat.


        :param disconnect_type: The disconnect_type of this ConversationChat.
        :type: str
        """
        allowed_values = ["ENDPOINT", "CLIENT", "SYSTEM", "TRANSFER", "TRANSFER_CONFERENCE", "TRANSFER_CONSULT", "TRANSFER_FORWARD", "ERROR", "PEER", "OTHER"]
        if disconnect_type not in allowed_values:
            raise ValueError(
                "Invalid value for `disconnect_type`, must be one of {0}"
                .format(allowed_values)
            )

        self._disconnect_type = disconnect_type

    @property
    def start_hold_time(self):
        """
        Gets the start_hold_time of this ConversationChat.
        Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :return: The start_hold_time of this ConversationChat.
        :rtype: datetime
        """
        return self._start_hold_time

    @start_hold_time.setter
    def start_hold_time(self, start_hold_time):
        """
        Sets the start_hold_time of this ConversationChat.
        Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :param start_hold_time: The start_hold_time of this ConversationChat.
        :type: datetime
        """
        
        self._start_hold_time = start_hold_time

    @property
    def connected_time(self):
        """
        Gets the connected_time of this ConversationChat.
        Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :return: The connected_time of this ConversationChat.
        :rtype: datetime
        """
        return self._connected_time

    @connected_time.setter
    def connected_time(self, connected_time):
        """
        Sets the connected_time of this ConversationChat.
        Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :param connected_time: The connected_time of this ConversationChat.
        :type: datetime
        """
        
        self._connected_time = connected_time

    @property
    def disconnected_time(self):
        """
        Gets the disconnected_time of this ConversationChat.
        Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :return: The disconnected_time of this ConversationChat.
        :rtype: datetime
        """
        return self._disconnected_time

    @disconnected_time.setter
    def disconnected_time(self, disconnected_time):
        """
        Sets the disconnected_time of this ConversationChat.
        Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :param disconnected_time: The disconnected_time of this ConversationChat.
        :type: datetime
        """
        
        self._disconnected_time = disconnected_time

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

