# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re


class CreateShareRequest(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        CreateShareRequest - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'shared_entity_type': 'str',
            'shared_entity': 'SharedEntity',
            'member_type': 'str',
            'member': 'SharedEntity',
            'members': 'list[CreateShareRequestMember]'
        }

        self.attribute_map = {
            'shared_entity_type': 'sharedEntityType',
            'shared_entity': 'sharedEntity',
            'member_type': 'memberType',
            'member': 'member',
            'members': 'members'
        }

        self._shared_entity_type = None
        self._shared_entity = None
        self._member_type = None
        self._member = None
        self._members = None

    @property
    def shared_entity_type(self):
        """
        Gets the shared_entity_type of this CreateShareRequest.


        :return: The shared_entity_type of this CreateShareRequest.
        :rtype: str
        """
        return self._shared_entity_type

    @shared_entity_type.setter
    def shared_entity_type(self, shared_entity_type):
        """
        Sets the shared_entity_type of this CreateShareRequest.


        :param shared_entity_type: The shared_entity_type of this CreateShareRequest.
        :type: str
        """
        allowed_values = ["DOCUMENT"]
        if shared_entity_type not in allowed_values:
            raise ValueError(
                "Invalid value for `shared_entity_type`, must be one of {0}"
                .format(allowed_values)
            )

        self._shared_entity_type = shared_entity_type

    @property
    def shared_entity(self):
        """
        Gets the shared_entity of this CreateShareRequest.


        :return: The shared_entity of this CreateShareRequest.
        :rtype: SharedEntity
        """
        return self._shared_entity

    @shared_entity.setter
    def shared_entity(self, shared_entity):
        """
        Sets the shared_entity of this CreateShareRequest.


        :param shared_entity: The shared_entity of this CreateShareRequest.
        :type: SharedEntity
        """
        
        self._shared_entity = shared_entity

    @property
    def member_type(self):
        """
        Gets the member_type of this CreateShareRequest.


        :return: The member_type of this CreateShareRequest.
        :rtype: str
        """
        return self._member_type

    @member_type.setter
    def member_type(self, member_type):
        """
        Sets the member_type of this CreateShareRequest.


        :param member_type: The member_type of this CreateShareRequest.
        :type: str
        """
        allowed_values = ["USER", "GROUP", "PUBLIC"]
        if member_type not in allowed_values:
            raise ValueError(
                "Invalid value for `member_type`, must be one of {0}"
                .format(allowed_values)
            )

        self._member_type = member_type

    @property
    def member(self):
        """
        Gets the member of this CreateShareRequest.


        :return: The member of this CreateShareRequest.
        :rtype: SharedEntity
        """
        return self._member

    @member.setter
    def member(self, member):
        """
        Sets the member of this CreateShareRequest.


        :param member: The member of this CreateShareRequest.
        :type: SharedEntity
        """
        
        self._member = member

    @property
    def members(self):
        """
        Gets the members of this CreateShareRequest.


        :return: The members of this CreateShareRequest.
        :rtype: list[CreateShareRequestMember]
        """
        return self._members

    @members.setter
    def members(self, members):
        """
        Sets the members of this CreateShareRequest.


        :param members: The members of this CreateShareRequest.
        :type: list[CreateShareRequestMember]
        """
        
        self._members = members

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

