# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re


class CsvSchema(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        CsvSchema - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'carrier_id': 'str',
            'header_row': 'int',
            'data_row': 'int',
            'header_mappings': 'dict(str, str)',
            'rate_type': 'str',
            'name': 'str',
            'date_format': 'str'
        }

        self.attribute_map = {
            'carrier_id': 'CarrierId',
            'header_row': 'HeaderRow',
            'data_row': 'DataRow',
            'header_mappings': 'HeaderMappings',
            'rate_type': 'RateType',
            'name': 'Name',
            'date_format': 'DateFormat'
        }

        self._carrier_id = None
        self._header_row = None
        self._data_row = None
        self._header_mappings = None
        self._rate_type = None
        self._name = None
        self._date_format = None

    @property
    def carrier_id(self):
        """
        Gets the carrier_id of this CsvSchema.
        Carrier ID associated with this CSV schema.

        :return: The carrier_id of this CsvSchema.
        :rtype: str
        """
        return self._carrier_id

    @carrier_id.setter
    def carrier_id(self, carrier_id):
        """
        Sets the carrier_id of this CsvSchema.
        Carrier ID associated with this CSV schema.

        :param carrier_id: The carrier_id of this CsvSchema.
        :type: str
        """
        
        self._carrier_id = carrier_id

    @property
    def header_row(self):
        """
        Gets the header_row of this CsvSchema.
        Row number for the CSV's headers.  This is zero indexed (i.e. 0 is row 1).

        :return: The header_row of this CsvSchema.
        :rtype: int
        """
        return self._header_row

    @header_row.setter
    def header_row(self, header_row):
        """
        Sets the header_row of this CsvSchema.
        Row number for the CSV's headers.  This is zero indexed (i.e. 0 is row 1).

        :param header_row: The header_row of this CsvSchema.
        :type: int
        """
        
        self._header_row = header_row

    @property
    def data_row(self):
        """
        Gets the data_row of this CsvSchema.
        Row number of the first line of data.  This is zero indexed (i.e. 0 is row 1).

        :return: The data_row of this CsvSchema.
        :rtype: int
        """
        return self._data_row

    @data_row.setter
    def data_row(self, data_row):
        """
        Sets the data_row of this CsvSchema.
        Row number of the first line of data.  This is zero indexed (i.e. 0 is row 1).

        :param data_row: The data_row of this CsvSchema.
        :type: int
        """
        
        self._data_row = data_row

    @property
    def header_mappings(self):
        """
        Gets the header_mappings of this CsvSchema.
        CSV header name to object name mappings. For example, \"ROUTE_TEL_PREFIX\" to \"Prefix\" might be one such mapping.

        :return: The header_mappings of this CsvSchema.
        :rtype: dict(str, str)
        """
        return self._header_mappings

    @header_mappings.setter
    def header_mappings(self, header_mappings):
        """
        Sets the header_mappings of this CsvSchema.
        CSV header name to object name mappings. For example, \"ROUTE_TEL_PREFIX\" to \"Prefix\" might be one such mapping.

        :param header_mappings: The header_mappings of this CsvSchema.
        :type: dict(str, str)
        """
        
        self._header_mappings = header_mappings

    @property
    def rate_type(self):
        """
        Gets the rate_type of this CsvSchema.
        Rate type for the sheet.

        :return: The rate_type of this CsvSchema.
        :rtype: str
        """
        return self._rate_type

    @rate_type.setter
    def rate_type(self, rate_type):
        """
        Sets the rate_type of this CsvSchema.
        Rate type for the sheet.

        :param rate_type: The rate_type of this CsvSchema.
        :type: str
        """
        allowed_values = ["INTRASTATE", "INTERSTATE", "INTERNATIONAL"]
        if rate_type not in allowed_values:
            raise ValueError(
                "Invalid value for `rate_type`, must be one of {0}"
                .format(allowed_values)
            )

        self._rate_type = rate_type

    @property
    def name(self):
        """
        Gets the name of this CsvSchema.
        Human readable name for schema.

        :return: The name of this CsvSchema.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this CsvSchema.
        Human readable name for schema.

        :param name: The name of this CsvSchema.
        :type: str
        """
        
        self._name = name

    @property
    def date_format(self):
        """
        Gets the date_format of this CsvSchema.
        A date format that represents the date time stamp you want to parse. This is based on the reference time of Mon Jan 2 15:04:05 MST 2006. For example, if you had the date 13-OCT-2015, this parameter should be 02-Jan-2006. As another example, if you have the date 2014-09-20, this parameter should be 2006-01-02.

        :return: The date_format of this CsvSchema.
        :rtype: str
        """
        return self._date_format

    @date_format.setter
    def date_format(self, date_format):
        """
        Sets the date_format of this CsvSchema.
        A date format that represents the date time stamp you want to parse. This is based on the reference time of Mon Jan 2 15:04:05 MST 2006. For example, if you had the date 13-OCT-2015, this parameter should be 02-Jan-2006. As another example, if you have the date 2014-09-20, this parameter should be 2006-01-02.

        :param date_format: The date_format of this CsvSchema.
        :type: str
        """
        
        self._date_format = date_format

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

