# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re


class CustomerAccount(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        CustomerAccount - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'is_frozen': 'bool',
            'org_legal_name': 'str',
            'org_phone': 'str',
            'is_tax_exempt': 'bool',
            'billing_address': 'BillingAddress',
            'currency': 'str',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'is_frozen': 'isFrozen',
            'org_legal_name': 'orgLegalName',
            'org_phone': 'orgPhone',
            'is_tax_exempt': 'isTaxExempt',
            'billing_address': 'billingAddress',
            'currency': 'currency',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._name = None
        self._is_frozen = False
        self._org_legal_name = None
        self._org_phone = None
        self._is_tax_exempt = False
        self._billing_address = None
        self._currency = None
        self._self_uri = None

    @property
    def id(self):
        """
        Gets the id of this CustomerAccount.
        The globally unique identifier for the object.

        :return: The id of this CustomerAccount.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this CustomerAccount.
        The globally unique identifier for the object.

        :param id: The id of this CustomerAccount.
        :type: str
        """
        
        self._id = id

    @property
    def name(self):
        """
        Gets the name of this CustomerAccount.


        :return: The name of this CustomerAccount.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this CustomerAccount.


        :param name: The name of this CustomerAccount.
        :type: str
        """
        
        self._name = name

    @property
    def is_frozen(self):
        """
        Gets the is_frozen of this CustomerAccount.
        Indicates whether the account is currently frozen for review.

        :return: The is_frozen of this CustomerAccount.
        :rtype: bool
        """
        return self._is_frozen

    @is_frozen.setter
    def is_frozen(self, is_frozen):
        """
        Sets the is_frozen of this CustomerAccount.
        Indicates whether the account is currently frozen for review.

        :param is_frozen: The is_frozen of this CustomerAccount.
        :type: bool
        """
        
        self._is_frozen = is_frozen

    @property
    def org_legal_name(self):
        """
        Gets the org_legal_name of this CustomerAccount.
        The organization legal name.

        :return: The org_legal_name of this CustomerAccount.
        :rtype: str
        """
        return self._org_legal_name

    @org_legal_name.setter
    def org_legal_name(self, org_legal_name):
        """
        Sets the org_legal_name of this CustomerAccount.
        The organization legal name.

        :param org_legal_name: The org_legal_name of this CustomerAccount.
        :type: str
        """
        
        self._org_legal_name = org_legal_name

    @property
    def org_phone(self):
        """
        Gets the org_phone of this CustomerAccount.
        The organization phone number.

        :return: The org_phone of this CustomerAccount.
        :rtype: str
        """
        return self._org_phone

    @org_phone.setter
    def org_phone(self, org_phone):
        """
        Sets the org_phone of this CustomerAccount.
        The organization phone number.

        :param org_phone: The org_phone of this CustomerAccount.
        :type: str
        """
        
        self._org_phone = org_phone

    @property
    def is_tax_exempt(self):
        """
        Gets the is_tax_exempt of this CustomerAccount.
        Indicates whether the account is tax exempt.

        :return: The is_tax_exempt of this CustomerAccount.
        :rtype: bool
        """
        return self._is_tax_exempt

    @is_tax_exempt.setter
    def is_tax_exempt(self, is_tax_exempt):
        """
        Sets the is_tax_exempt of this CustomerAccount.
        Indicates whether the account is tax exempt.

        :param is_tax_exempt: The is_tax_exempt of this CustomerAccount.
        :type: bool
        """
        
        self._is_tax_exempt = is_tax_exempt

    @property
    def billing_address(self):
        """
        Gets the billing_address of this CustomerAccount.
        The account billing address.

        :return: The billing_address of this CustomerAccount.
        :rtype: BillingAddress
        """
        return self._billing_address

    @billing_address.setter
    def billing_address(self, billing_address):
        """
        Sets the billing_address of this CustomerAccount.
        The account billing address.

        :param billing_address: The billing_address of this CustomerAccount.
        :type: BillingAddress
        """
        
        self._billing_address = billing_address

    @property
    def currency(self):
        """
        Gets the currency of this CustomerAccount.
        The account currency.

        :return: The currency of this CustomerAccount.
        :rtype: str
        """
        return self._currency

    @currency.setter
    def currency(self, currency):
        """
        Sets the currency of this CustomerAccount.
        The account currency.

        :param currency: The currency of this CustomerAccount.
        :type: str
        """
        
        self._currency = currency

    @property
    def self_uri(self):
        """
        Gets the self_uri of this CustomerAccount.
        The URI for this object

        :return: The self_uri of this CustomerAccount.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri):
        """
        Sets the self_uri of this CustomerAccount.
        The URI for this object

        :param self_uri: The self_uri of this CustomerAccount.
        :type: str
        """
        
        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

