# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re


class DeltaDocument(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        DeltaDocument - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'filename': 'str',
            'content_type': 'str',
            'content_length_bytes': 'int',
            'operation': 'str',
            'date_modified': 'datetime'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'filename': 'filename',
            'content_type': 'contentType',
            'content_length_bytes': 'contentLengthBytes',
            'operation': 'operation',
            'date_modified': 'dateModified'
        }

        self._id = None
        self._name = None
        self._filename = None
        self._content_type = None
        self._content_length_bytes = None
        self._operation = None
        self._date_modified = None

    @property
    def id(self):
        """
        Gets the id of this DeltaDocument.


        :return: The id of this DeltaDocument.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this DeltaDocument.


        :param id: The id of this DeltaDocument.
        :type: str
        """
        
        self._id = id

    @property
    def name(self):
        """
        Gets the name of this DeltaDocument.


        :return: The name of this DeltaDocument.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this DeltaDocument.


        :param name: The name of this DeltaDocument.
        :type: str
        """
        
        self._name = name

    @property
    def filename(self):
        """
        Gets the filename of this DeltaDocument.


        :return: The filename of this DeltaDocument.
        :rtype: str
        """
        return self._filename

    @filename.setter
    def filename(self, filename):
        """
        Sets the filename of this DeltaDocument.


        :param filename: The filename of this DeltaDocument.
        :type: str
        """
        
        self._filename = filename

    @property
    def content_type(self):
        """
        Gets the content_type of this DeltaDocument.


        :return: The content_type of this DeltaDocument.
        :rtype: str
        """
        return self._content_type

    @content_type.setter
    def content_type(self, content_type):
        """
        Sets the content_type of this DeltaDocument.


        :param content_type: The content_type of this DeltaDocument.
        :type: str
        """
        
        self._content_type = content_type

    @property
    def content_length_bytes(self):
        """
        Gets the content_length_bytes of this DeltaDocument.


        :return: The content_length_bytes of this DeltaDocument.
        :rtype: int
        """
        return self._content_length_bytes

    @content_length_bytes.setter
    def content_length_bytes(self, content_length_bytes):
        """
        Sets the content_length_bytes of this DeltaDocument.


        :param content_length_bytes: The content_length_bytes of this DeltaDocument.
        :type: int
        """
        
        self._content_length_bytes = content_length_bytes

    @property
    def operation(self):
        """
        Gets the operation of this DeltaDocument.


        :return: The operation of this DeltaDocument.
        :rtype: str
        """
        return self._operation

    @operation.setter
    def operation(self, operation):
        """
        Sets the operation of this DeltaDocument.


        :param operation: The operation of this DeltaDocument.
        :type: str
        """
        allowed_values = ["CREATED", "UPDATED", "REPLACED", "DELETED"]
        if operation not in allowed_values:
            raise ValueError(
                "Invalid value for `operation`, must be one of {0}"
                .format(allowed_values)
            )

        self._operation = operation

    @property
    def date_modified(self):
        """
        Gets the date_modified of this DeltaDocument.
        Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :return: The date_modified of this DeltaDocument.
        :rtype: datetime
        """
        return self._date_modified

    @date_modified.setter
    def date_modified(self, date_modified):
        """
        Sets the date_modified of this DeltaDocument.
        Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :param date_modified: The date_modified of this DeltaDocument.
        :type: datetime
        """
        
        self._date_modified = date_modified

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

