# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re


class DeltaResponse(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        DeltaResponse - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'context_token': 'str',
            'documents': 'list[DeltaDocument]',
            'has_more': 'bool'
        }

        self.attribute_map = {
            'context_token': 'contextToken',
            'documents': 'documents',
            'has_more': 'hasMore'
        }

        self._context_token = None
        self._documents = None
        self._has_more = False

    @property
    def context_token(self):
        """
        Gets the context_token of this DeltaResponse.


        :return: The context_token of this DeltaResponse.
        :rtype: str
        """
        return self._context_token

    @context_token.setter
    def context_token(self, context_token):
        """
        Sets the context_token of this DeltaResponse.


        :param context_token: The context_token of this DeltaResponse.
        :type: str
        """
        
        self._context_token = context_token

    @property
    def documents(self):
        """
        Gets the documents of this DeltaResponse.


        :return: The documents of this DeltaResponse.
        :rtype: list[DeltaDocument]
        """
        return self._documents

    @documents.setter
    def documents(self, documents):
        """
        Sets the documents of this DeltaResponse.


        :param documents: The documents of this DeltaResponse.
        :type: list[DeltaDocument]
        """
        
        self._documents = documents

    @property
    def has_more(self):
        """
        Gets the has_more of this DeltaResponse.


        :return: The has_more of this DeltaResponse.
        :rtype: bool
        """
        return self._has_more

    @has_more.setter
    def has_more(self, has_more):
        """
        Sets the has_more of this DeltaResponse.


        :param has_more: The has_more of this DeltaResponse.
        :type: bool
        """
        
        self._has_more = has_more

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

