# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re


class Discount(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        Discount - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'annual_pre_pay': 'bool',
            'discount': 'str',
            'maximum': 'str',
            'minimum': 'str',
            'product_category': 'str',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'annual_pre_pay': 'annualPrePay',
            'discount': 'discount',
            'maximum': 'maximum',
            'minimum': 'minimum',
            'product_category': 'productCategory',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._name = None
        self._annual_pre_pay = False
        self._discount = None
        self._maximum = None
        self._minimum = None
        self._product_category = None
        self._self_uri = None

    @property
    def id(self):
        """
        Gets the id of this Discount.
        The globally unique identifier for the object.

        :return: The id of this Discount.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this Discount.
        The globally unique identifier for the object.

        :param id: The id of this Discount.
        :type: str
        """
        
        self._id = id

    @property
    def name(self):
        """
        Gets the name of this Discount.


        :return: The name of this Discount.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this Discount.


        :param name: The name of this Discount.
        :type: str
        """
        
        self._name = name

    @property
    def annual_pre_pay(self):
        """
        Gets the annual_pre_pay of this Discount.


        :return: The annual_pre_pay of this Discount.
        :rtype: bool
        """
        return self._annual_pre_pay

    @annual_pre_pay.setter
    def annual_pre_pay(self, annual_pre_pay):
        """
        Sets the annual_pre_pay of this Discount.


        :param annual_pre_pay: The annual_pre_pay of this Discount.
        :type: bool
        """
        
        self._annual_pre_pay = annual_pre_pay

    @property
    def discount(self):
        """
        Gets the discount of this Discount.


        :return: The discount of this Discount.
        :rtype: str
        """
        return self._discount

    @discount.setter
    def discount(self, discount):
        """
        Sets the discount of this Discount.


        :param discount: The discount of this Discount.
        :type: str
        """
        
        self._discount = discount

    @property
    def maximum(self):
        """
        Gets the maximum of this Discount.


        :return: The maximum of this Discount.
        :rtype: str
        """
        return self._maximum

    @maximum.setter
    def maximum(self, maximum):
        """
        Sets the maximum of this Discount.


        :param maximum: The maximum of this Discount.
        :type: str
        """
        
        self._maximum = maximum

    @property
    def minimum(self):
        """
        Gets the minimum of this Discount.


        :return: The minimum of this Discount.
        :rtype: str
        """
        return self._minimum

    @minimum.setter
    def minimum(self, minimum):
        """
        Sets the minimum of this Discount.


        :param minimum: The minimum of this Discount.
        :type: str
        """
        
        self._minimum = minimum

    @property
    def product_category(self):
        """
        Gets the product_category of this Discount.


        :return: The product_category of this Discount.
        :rtype: str
        """
        return self._product_category

    @product_category.setter
    def product_category(self, product_category):
        """
        Sets the product_category of this Discount.


        :param product_category: The product_category of this Discount.
        :type: str
        """
        
        self._product_category = product_category

    @property
    def self_uri(self):
        """
        Gets the self_uri of this Discount.
        The URI for this object

        :return: The self_uri of this Discount.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri):
        """
        Sets the self_uri of this Discount.
        The URI for this object

        :param self_uri: The self_uri of this Discount.
        :type: str
        """
        
        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

