# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re


class DomainPhysicalInterface(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        DomainPhysicalInterface - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'edge_uri': 'str',
            'friendly_name': 'str',
            'hardware_address': 'str',
            'port_label': 'str',
            'physical_capabilities': 'DomainPhysicalCapabilities',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'edge_uri': 'edgeUri',
            'friendly_name': 'friendlyName',
            'hardware_address': 'hardwareAddress',
            'port_label': 'portLabel',
            'physical_capabilities': 'physicalCapabilities',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._name = None
        self._edge_uri = None
        self._friendly_name = None
        self._hardware_address = None
        self._port_label = None
        self._physical_capabilities = None
        self._self_uri = None

    @property
    def id(self):
        """
        Gets the id of this DomainPhysicalInterface.
        The globally unique identifier for the object.

        :return: The id of this DomainPhysicalInterface.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this DomainPhysicalInterface.
        The globally unique identifier for the object.

        :param id: The id of this DomainPhysicalInterface.
        :type: str
        """
        
        self._id = id

    @property
    def name(self):
        """
        Gets the name of this DomainPhysicalInterface.


        :return: The name of this DomainPhysicalInterface.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this DomainPhysicalInterface.


        :param name: The name of this DomainPhysicalInterface.
        :type: str
        """
        
        self._name = name

    @property
    def edge_uri(self):
        """
        Gets the edge_uri of this DomainPhysicalInterface.


        :return: The edge_uri of this DomainPhysicalInterface.
        :rtype: str
        """
        return self._edge_uri

    @edge_uri.setter
    def edge_uri(self, edge_uri):
        """
        Sets the edge_uri of this DomainPhysicalInterface.


        :param edge_uri: The edge_uri of this DomainPhysicalInterface.
        :type: str
        """
        
        self._edge_uri = edge_uri

    @property
    def friendly_name(self):
        """
        Gets the friendly_name of this DomainPhysicalInterface.


        :return: The friendly_name of this DomainPhysicalInterface.
        :rtype: str
        """
        return self._friendly_name

    @friendly_name.setter
    def friendly_name(self, friendly_name):
        """
        Sets the friendly_name of this DomainPhysicalInterface.


        :param friendly_name: The friendly_name of this DomainPhysicalInterface.
        :type: str
        """
        
        self._friendly_name = friendly_name

    @property
    def hardware_address(self):
        """
        Gets the hardware_address of this DomainPhysicalInterface.


        :return: The hardware_address of this DomainPhysicalInterface.
        :rtype: str
        """
        return self._hardware_address

    @hardware_address.setter
    def hardware_address(self, hardware_address):
        """
        Sets the hardware_address of this DomainPhysicalInterface.


        :param hardware_address: The hardware_address of this DomainPhysicalInterface.
        :type: str
        """
        
        self._hardware_address = hardware_address

    @property
    def port_label(self):
        """
        Gets the port_label of this DomainPhysicalInterface.


        :return: The port_label of this DomainPhysicalInterface.
        :rtype: str
        """
        return self._port_label

    @port_label.setter
    def port_label(self, port_label):
        """
        Sets the port_label of this DomainPhysicalInterface.


        :param port_label: The port_label of this DomainPhysicalInterface.
        :type: str
        """
        
        self._port_label = port_label

    @property
    def physical_capabilities(self):
        """
        Gets the physical_capabilities of this DomainPhysicalInterface.


        :return: The physical_capabilities of this DomainPhysicalInterface.
        :rtype: DomainPhysicalCapabilities
        """
        return self._physical_capabilities

    @physical_capabilities.setter
    def physical_capabilities(self, physical_capabilities):
        """
        Sets the physical_capabilities of this DomainPhysicalInterface.


        :param physical_capabilities: The physical_capabilities of this DomainPhysicalInterface.
        :type: DomainPhysicalCapabilities
        """
        
        self._physical_capabilities = physical_capabilities

    @property
    def self_uri(self):
        """
        Gets the self_uri of this DomainPhysicalInterface.
        The URI for this object

        :return: The self_uri of this DomainPhysicalInterface.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri):
        """
        Sets the self_uri of this DomainPhysicalInterface.
        The URI for this object

        :param self_uri: The self_uri of this DomainPhysicalInterface.
        :type: str
        """
        
        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

