# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re


class EdgeLogsJobFile(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        EdgeLogsJobFile - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'time_created': 'datetime',
            'time_modified': 'datetime',
            'size_bytes': 'float',
            'upload_status': 'str',
            'edge_path': 'str',
            'download_id': 'str',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'time_created': 'timeCreated',
            'time_modified': 'timeModified',
            'size_bytes': 'sizeBytes',
            'upload_status': 'uploadStatus',
            'edge_path': 'edgePath',
            'download_id': 'downloadId',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._name = None
        self._time_created = None
        self._time_modified = None
        self._size_bytes = None
        self._upload_status = None
        self._edge_path = None
        self._download_id = None
        self._self_uri = None

    @property
    def id(self):
        """
        Gets the id of this EdgeLogsJobFile.
        The globally unique identifier for the object.

        :return: The id of this EdgeLogsJobFile.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this EdgeLogsJobFile.
        The globally unique identifier for the object.

        :param id: The id of this EdgeLogsJobFile.
        :type: str
        """
        
        self._id = id

    @property
    def name(self):
        """
        Gets the name of this EdgeLogsJobFile.


        :return: The name of this EdgeLogsJobFile.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this EdgeLogsJobFile.


        :param name: The name of this EdgeLogsJobFile.
        :type: str
        """
        
        self._name = name

    @property
    def time_created(self):
        """
        Gets the time_created of this EdgeLogsJobFile.
        Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :return: The time_created of this EdgeLogsJobFile.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this EdgeLogsJobFile.
        Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :param time_created: The time_created of this EdgeLogsJobFile.
        :type: datetime
        """
        
        self._time_created = time_created

    @property
    def time_modified(self):
        """
        Gets the time_modified of this EdgeLogsJobFile.
        The time this log file was last modified on the Edge. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :return: The time_modified of this EdgeLogsJobFile.
        :rtype: datetime
        """
        return self._time_modified

    @time_modified.setter
    def time_modified(self, time_modified):
        """
        Sets the time_modified of this EdgeLogsJobFile.
        The time this log file was last modified on the Edge. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :param time_modified: The time_modified of this EdgeLogsJobFile.
        :type: datetime
        """
        
        self._time_modified = time_modified

    @property
    def size_bytes(self):
        """
        Gets the size_bytes of this EdgeLogsJobFile.
        The size of this file in bytes.

        :return: The size_bytes of this EdgeLogsJobFile.
        :rtype: float
        """
        return self._size_bytes

    @size_bytes.setter
    def size_bytes(self, size_bytes):
        """
        Sets the size_bytes of this EdgeLogsJobFile.
        The size of this file in bytes.

        :param size_bytes: The size_bytes of this EdgeLogsJobFile.
        :type: float
        """
        
        self._size_bytes = size_bytes

    @property
    def upload_status(self):
        """
        Gets the upload_status of this EdgeLogsJobFile.
        The status of the upload of this file from the Edge to the cloud.  Use /upload to start an upload.

        :return: The upload_status of this EdgeLogsJobFile.
        :rtype: str
        """
        return self._upload_status

    @upload_status.setter
    def upload_status(self, upload_status):
        """
        Sets the upload_status of this EdgeLogsJobFile.
        The status of the upload of this file from the Edge to the cloud.  Use /upload to start an upload.

        :param upload_status: The upload_status of this EdgeLogsJobFile.
        :type: str
        """
        allowed_values = ["UPLOADING", "NOT_UPLOADED", "UPLOADED", "ERROR_ON_UPLOAD"]
        if upload_status not in allowed_values:
            raise ValueError(
                "Invalid value for `upload_status`, must be one of {0}"
                .format(allowed_values)
            )

        self._upload_status = upload_status

    @property
    def edge_path(self):
        """
        Gets the edge_path of this EdgeLogsJobFile.
        The path of this file on the Edge.

        :return: The edge_path of this EdgeLogsJobFile.
        :rtype: str
        """
        return self._edge_path

    @edge_path.setter
    def edge_path(self, edge_path):
        """
        Sets the edge_path of this EdgeLogsJobFile.
        The path of this file on the Edge.

        :param edge_path: The edge_path of this EdgeLogsJobFile.
        :type: str
        """
        
        self._edge_path = edge_path

    @property
    def download_id(self):
        """
        Gets the download_id of this EdgeLogsJobFile.
        The download ID to use with the downloads API.

        :return: The download_id of this EdgeLogsJobFile.
        :rtype: str
        """
        return self._download_id

    @download_id.setter
    def download_id(self, download_id):
        """
        Sets the download_id of this EdgeLogsJobFile.
        The download ID to use with the downloads API.

        :param download_id: The download_id of this EdgeLogsJobFile.
        :type: str
        """
        
        self._download_id = download_id

    @property
    def self_uri(self):
        """
        Gets the self_uri of this EdgeLogsJobFile.
        The URI for this object

        :return: The self_uri of this EdgeLogsJobFile.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri):
        """
        Sets the self_uri of this EdgeLogsJobFile.
        The URI for this object

        :param self_uri: The self_uri of this EdgeLogsJobFile.
        :type: str
        """
        
        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

