# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re


class EmailAttachment(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        EmailAttachment - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'name': 'str',
            'content_path': 'str',
            'content_type': 'str',
            'attachment_id': 'str',
            'content_length': 'int'
        }

        self.attribute_map = {
            'name': 'name',
            'content_path': 'contentPath',
            'content_type': 'contentType',
            'attachment_id': 'attachmentId',
            'content_length': 'contentLength'
        }

        self._name = None
        self._content_path = None
        self._content_type = None
        self._attachment_id = None
        self._content_length = None

    @property
    def name(self):
        """
        Gets the name of this EmailAttachment.


        :return: The name of this EmailAttachment.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this EmailAttachment.


        :param name: The name of this EmailAttachment.
        :type: str
        """
        
        self._name = name

    @property
    def content_path(self):
        """
        Gets the content_path of this EmailAttachment.


        :return: The content_path of this EmailAttachment.
        :rtype: str
        """
        return self._content_path

    @content_path.setter
    def content_path(self, content_path):
        """
        Sets the content_path of this EmailAttachment.


        :param content_path: The content_path of this EmailAttachment.
        :type: str
        """
        
        self._content_path = content_path

    @property
    def content_type(self):
        """
        Gets the content_type of this EmailAttachment.


        :return: The content_type of this EmailAttachment.
        :rtype: str
        """
        return self._content_type

    @content_type.setter
    def content_type(self, content_type):
        """
        Sets the content_type of this EmailAttachment.


        :param content_type: The content_type of this EmailAttachment.
        :type: str
        """
        
        self._content_type = content_type

    @property
    def attachment_id(self):
        """
        Gets the attachment_id of this EmailAttachment.


        :return: The attachment_id of this EmailAttachment.
        :rtype: str
        """
        return self._attachment_id

    @attachment_id.setter
    def attachment_id(self, attachment_id):
        """
        Sets the attachment_id of this EmailAttachment.


        :param attachment_id: The attachment_id of this EmailAttachment.
        :type: str
        """
        
        self._attachment_id = attachment_id

    @property
    def content_length(self):
        """
        Gets the content_length of this EmailAttachment.


        :return: The content_length of this EmailAttachment.
        :rtype: int
        """
        return self._content_length

    @content_length.setter
    def content_length(self, content_length):
        """
        Sets the content_length of this EmailAttachment.


        :param content_length: The content_length of this EmailAttachment.
        :type: int
        """
        
        self._content_length = content_length

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

