# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re


class ExpressionResponse(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        ExpressionResponse - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'date_created': 'datetime',
            'date_modified': 'datetime',
            'social_hub': 'str',
            'conversation': 'Conversation',
            'twitter_expression': 'TwitterExpression',
            'raw_response_text': 'str',
            'social_account': 'SocialAccount',
            'social_hub_response_id': 'str',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'date_created': 'dateCreated',
            'date_modified': 'dateModified',
            'social_hub': 'socialHub',
            'conversation': 'conversation',
            'twitter_expression': 'twitterExpression',
            'raw_response_text': 'rawResponseText',
            'social_account': 'socialAccount',
            'social_hub_response_id': 'socialHubResponseId',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._name = None
        self._date_created = None
        self._date_modified = None
        self._social_hub = None
        self._conversation = None
        self._twitter_expression = None
        self._raw_response_text = None
        self._social_account = None
        self._social_hub_response_id = None
        self._self_uri = None

    @property
    def id(self):
        """
        Gets the id of this ExpressionResponse.
        The globally unique identifier for the object.

        :return: The id of this ExpressionResponse.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this ExpressionResponse.
        The globally unique identifier for the object.

        :param id: The id of this ExpressionResponse.
        :type: str
        """
        
        self._id = id

    @property
    def name(self):
        """
        Gets the name of this ExpressionResponse.


        :return: The name of this ExpressionResponse.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this ExpressionResponse.


        :param name: The name of this ExpressionResponse.
        :type: str
        """
        
        self._name = name

    @property
    def date_created(self):
        """
        Gets the date_created of this ExpressionResponse.
        Creation date for the entity. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :return: The date_created of this ExpressionResponse.
        :rtype: datetime
        """
        return self._date_created

    @date_created.setter
    def date_created(self, date_created):
        """
        Sets the date_created of this ExpressionResponse.
        Creation date for the entity. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :param date_created: The date_created of this ExpressionResponse.
        :type: datetime
        """
        
        self._date_created = date_created

    @property
    def date_modified(self):
        """
        Gets the date_modified of this ExpressionResponse.
        Date the entity was last modified. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :return: The date_modified of this ExpressionResponse.
        :rtype: datetime
        """
        return self._date_modified

    @date_modified.setter
    def date_modified(self, date_modified):
        """
        Sets the date_modified of this ExpressionResponse.
        Date the entity was last modified. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :param date_modified: The date_modified of this ExpressionResponse.
        :type: datetime
        """
        
        self._date_modified = date_modified

    @property
    def social_hub(self):
        """
        Gets the social_hub of this ExpressionResponse.
        The name of the social hub.

        :return: The social_hub of this ExpressionResponse.
        :rtype: str
        """
        return self._social_hub

    @social_hub.setter
    def social_hub(self, social_hub):
        """
        Sets the social_hub of this ExpressionResponse.
        The name of the social hub.

        :param social_hub: The social_hub of this ExpressionResponse.
        :type: str
        """
        
        self._social_hub = social_hub

    @property
    def conversation(self):
        """
        Gets the conversation of this ExpressionResponse.
        The conversation that this response is a part of.

        :return: The conversation of this ExpressionResponse.
        :rtype: Conversation
        """
        return self._conversation

    @conversation.setter
    def conversation(self, conversation):
        """
        Sets the conversation of this ExpressionResponse.
        The conversation that this response is a part of.

        :param conversation: The conversation of this ExpressionResponse.
        :type: Conversation
        """
        
        self._conversation = conversation

    @property
    def twitter_expression(self):
        """
        Gets the twitter_expression of this ExpressionResponse.
        The twitter expression that this is in response to.

        :return: The twitter_expression of this ExpressionResponse.
        :rtype: TwitterExpression
        """
        return self._twitter_expression

    @twitter_expression.setter
    def twitter_expression(self, twitter_expression):
        """
        Sets the twitter_expression of this ExpressionResponse.
        The twitter expression that this is in response to.

        :param twitter_expression: The twitter_expression of this ExpressionResponse.
        :type: TwitterExpression
        """
        
        self._twitter_expression = twitter_expression

    @property
    def raw_response_text(self):
        """
        Gets the raw_response_text of this ExpressionResponse.
        The raw text of the response.

        :return: The raw_response_text of this ExpressionResponse.
        :rtype: str
        """
        return self._raw_response_text

    @raw_response_text.setter
    def raw_response_text(self, raw_response_text):
        """
        Sets the raw_response_text of this ExpressionResponse.
        The raw text of the response.

        :param raw_response_text: The raw_response_text of this ExpressionResponse.
        :type: str
        """
        
        self._raw_response_text = raw_response_text

    @property
    def social_account(self):
        """
        Gets the social_account of this ExpressionResponse.
        The Social Account used to publish this expression

        :return: The social_account of this ExpressionResponse.
        :rtype: SocialAccount
        """
        return self._social_account

    @social_account.setter
    def social_account(self, social_account):
        """
        Sets the social_account of this ExpressionResponse.
        The Social Account used to publish this expression

        :param social_account: The social_account of this ExpressionResponse.
        :type: SocialAccount
        """
        
        self._social_account = social_account

    @property
    def social_hub_response_id(self):
        """
        Gets the social_hub_response_id of this ExpressionResponse.
        The id given to this response from the social hub

        :return: The social_hub_response_id of this ExpressionResponse.
        :rtype: str
        """
        return self._social_hub_response_id

    @social_hub_response_id.setter
    def social_hub_response_id(self, social_hub_response_id):
        """
        Sets the social_hub_response_id of this ExpressionResponse.
        The id given to this response from the social hub

        :param social_hub_response_id: The social_hub_response_id of this ExpressionResponse.
        :type: str
        """
        
        self._social_hub_response_id = social_hub_response_id

    @property
    def self_uri(self):
        """
        Gets the self_uri of this ExpressionResponse.
        The URI for this object

        :return: The self_uri of this ExpressionResponse.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri):
        """
        Sets the self_uri of this ExpressionResponse.
        The URI for this object

        :param self_uri: The self_uri of this ExpressionResponse.
        :type: str
        """
        
        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

