# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re


class FacetRequest(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        FacetRequest - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'name': 'str',
            'facet_request_query_type': 'str',
            'field_name': 'str',
            'type': 'str',
            'range_from': 'str',
            'range_to': 'str',
            'max_facet_count': 'int'
        }

        self.attribute_map = {
            'name': 'name',
            'facet_request_query_type': 'facetRequestQueryType',
            'field_name': 'fieldName',
            'type': 'type',
            'range_from': 'rangeFrom',
            'range_to': 'rangeTo',
            'max_facet_count': 'maxFacetCount'
        }

        self._name = None
        self._facet_request_query_type = None
        self._field_name = None
        self._type = None
        self._range_from = None
        self._range_to = None
        self._max_facet_count = None

    @property
    def name(self):
        """
        Gets the name of this FacetRequest.
        name of the facet request that will be returned with the result set

        :return: The name of this FacetRequest.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this FacetRequest.
        name of the facet request that will be returned with the result set

        :param name: The name of this FacetRequest.
        :type: str
        """
        
        self._name = name

    @property
    def facet_request_query_type(self):
        """
        Gets the facet_request_query_type of this FacetRequest.
        Which facet request type

        :return: The facet_request_query_type of this FacetRequest.
        :rtype: str
        """
        return self._facet_request_query_type

    @facet_request_query_type.setter
    def facet_request_query_type(self, facet_request_query_type):
        """
        Sets the facet_request_query_type of this FacetRequest.
        Which facet request type

        :param facet_request_query_type: The facet_request_query_type of this FacetRequest.
        :type: str
        """
        allowed_values = ["TERM", "RANGE"]
        if facet_request_query_type not in allowed_values:
            raise ValueError(
                "Invalid value for `facet_request_query_type`, must be one of {0}"
                .format(allowed_values)
            )

        self._facet_request_query_type = facet_request_query_type

    @property
    def field_name(self):
        """
        Gets the field_name of this FacetRequest.
        The fieldName to perform the facet request on.

        :return: The field_name of this FacetRequest.
        :rtype: str
        """
        return self._field_name

    @field_name.setter
    def field_name(self, field_name):
        """
        Sets the field_name of this FacetRequest.
        The fieldName to perform the facet request on.

        :param field_name: The field_name of this FacetRequest.
        :type: str
        """
        
        self._field_name = field_name

    @property
    def type(self):
        """
        Gets the type of this FacetRequest.
        the fieldtype of the field to perform the facet request on.

        :return: The type of this FacetRequest.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this FacetRequest.
        the fieldtype of the field to perform the facet request on.

        :param type: The type of this FacetRequest.
        :type: str
        """
        allowed_values = ["NUMBER", "STRING", "DATE", "BOOLEAN", "LIST", "GROUP"]
        if type not in allowed_values:
            raise ValueError(
                "Invalid value for `type`, must be one of {0}"
                .format(allowed_values)
            )

        self._type = type

    @property
    def range_from(self):
        """
        Gets the range_from of this FacetRequest.
        For RANGE requests populate this field to specify the beginning of a limit (leave blank for openended).  Note this value is inclusive of the results.  (EG if the value is 1, 1 will be included in the range.)

        :return: The range_from of this FacetRequest.
        :rtype: str
        """
        return self._range_from

    @range_from.setter
    def range_from(self, range_from):
        """
        Sets the range_from of this FacetRequest.
        For RANGE requests populate this field to specify the beginning of a limit (leave blank for openended).  Note this value is inclusive of the results.  (EG if the value is 1, 1 will be included in the range.)

        :param range_from: The range_from of this FacetRequest.
        :type: str
        """
        
        self._range_from = range_from

    @property
    def range_to(self):
        """
        Gets the range_to of this FacetRequest.
        For RANGE requests populate this field to specify the end of a limit (leave blank for openended).  Note this value is EXCLUSIVE of the result (EG if this value was 5, only values LESS THAN 5 will be included in the count.)

        :return: The range_to of this FacetRequest.
        :rtype: str
        """
        return self._range_to

    @range_to.setter
    def range_to(self, range_to):
        """
        Sets the range_to of this FacetRequest.
        For RANGE requests populate this field to specify the end of a limit (leave blank for openended).  Note this value is EXCLUSIVE of the result (EG if this value was 5, only values LESS THAN 5 will be included in the count.)

        :param range_to: The range_to of this FacetRequest.
        :type: str
        """
        
        self._range_to = range_to

    @property
    def max_facet_count(self):
        """
        Gets the max_facet_count of this FacetRequest.
        Limits/expands the number of facet entries returned (default 500)

        :return: The max_facet_count of this FacetRequest.
        :rtype: int
        """
        return self._max_facet_count

    @max_facet_count.setter
    def max_facet_count(self, max_facet_count):
        """
        Sets the max_facet_count of this FacetRequest.
        Limits/expands the number of facet entries returned (default 500)

        :param max_facet_count: The max_facet_count of this FacetRequest.
        :type: int
        """
        
        self._max_facet_count = max_facet_count

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

