# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re


class FacetResultItem(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        FacetResultItem - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'name': 'str',
            'count': 'int',
            'document': 'Document',
            'user': 'User',
            'queue': 'Queue',
            'flow_config_id': 'FlowConfigId',
            'workspace': 'Workspace'
        }

        self.attribute_map = {
            'name': 'name',
            'count': 'count',
            'document': 'document',
            'user': 'user',
            'queue': 'queue',
            'flow_config_id': 'flowConfigId',
            'workspace': 'workspace'
        }

        self._name = None
        self._count = None
        self._document = None
        self._user = None
        self._queue = None
        self._flow_config_id = None
        self._workspace = None

    @property
    def name(self):
        """
        Gets the name of this FacetResultItem.
        For TERM facets this will contain the value of the term that was found userid, docid, etc.

        :return: The name of this FacetResultItem.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this FacetResultItem.
        For TERM facets this will contain the value of the term that was found userid, docid, etc.

        :param name: The name of this FacetResultItem.
        :type: str
        """
        
        self._name = name

    @property
    def count(self):
        """
        Gets the count of this FacetResultItem.
        The number of items that matched the facetRequest.

        :return: The count of this FacetResultItem.
        :rtype: int
        """
        return self._count

    @count.setter
    def count(self, count):
        """
        Sets the count of this FacetResultItem.
        The number of items that matched the facetRequest.

        :param count: The count of this FacetResultItem.
        :type: int
        """
        
        self._count = count

    @property
    def document(self):
        """
        Gets the document of this FacetResultItem.


        :return: The document of this FacetResultItem.
        :rtype: Document
        """
        return self._document

    @document.setter
    def document(self, document):
        """
        Sets the document of this FacetResultItem.


        :param document: The document of this FacetResultItem.
        :type: Document
        """
        
        self._document = document

    @property
    def user(self):
        """
        Gets the user of this FacetResultItem.


        :return: The user of this FacetResultItem.
        :rtype: User
        """
        return self._user

    @user.setter
    def user(self, user):
        """
        Sets the user of this FacetResultItem.


        :param user: The user of this FacetResultItem.
        :type: User
        """
        
        self._user = user

    @property
    def queue(self):
        """
        Gets the queue of this FacetResultItem.


        :return: The queue of this FacetResultItem.
        :rtype: Queue
        """
        return self._queue

    @queue.setter
    def queue(self, queue):
        """
        Sets the queue of this FacetResultItem.


        :param queue: The queue of this FacetResultItem.
        :type: Queue
        """
        
        self._queue = queue

    @property
    def flow_config_id(self):
        """
        Gets the flow_config_id of this FacetResultItem.


        :return: The flow_config_id of this FacetResultItem.
        :rtype: FlowConfigId
        """
        return self._flow_config_id

    @flow_config_id.setter
    def flow_config_id(self, flow_config_id):
        """
        Sets the flow_config_id of this FacetResultItem.


        :param flow_config_id: The flow_config_id of this FacetResultItem.
        :type: FlowConfigId
        """
        
        self._flow_config_id = flow_config_id

    @property
    def workspace(self):
        """
        Gets the workspace of this FacetResultItem.


        :return: The workspace of this FacetResultItem.
        :rtype: Workspace
        """
        return self._workspace

    @workspace.setter
    def workspace(self, workspace):
        """
        Sets the workspace of this FacetResultItem.


        :param workspace: The workspace of this FacetResultItem.
        :type: Workspace
        """
        
        self._workspace = workspace

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

