# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re


class Flow(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        Flow - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'description': 'str',
            'type': 'str',
            'locked_user': 'UriReference',
            'active': 'bool',
            'deleted': 'bool',
            'published_version': 'FlowVersion',
            'checked_in_version': 'FlowVersion',
            'saved_version': 'FlowVersion',
            'system': 'bool',
            'publish_status': 'str',
            'published_by': 'UriReference',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'description': 'description',
            'type': 'type',
            'locked_user': 'lockedUser',
            'active': 'active',
            'deleted': 'deleted',
            'published_version': 'publishedVersion',
            'checked_in_version': 'checkedInVersion',
            'saved_version': 'savedVersion',
            'system': 'system',
            'publish_status': 'publishStatus',
            'published_by': 'publishedBy',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._name = None
        self._description = None
        self._type = None
        self._locked_user = None
        self._active = False
        self._deleted = False
        self._published_version = None
        self._checked_in_version = None
        self._saved_version = None
        self._system = False
        self._publish_status = None
        self._published_by = None
        self._self_uri = None

    @property
    def id(self):
        """
        Gets the id of this Flow.
        The globally unique identifier for the object.

        :return: The id of this Flow.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this Flow.
        The globally unique identifier for the object.

        :param id: The id of this Flow.
        :type: str
        """
        
        self._id = id

    @property
    def name(self):
        """
        Gets the name of this Flow.


        :return: The name of this Flow.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this Flow.


        :param name: The name of this Flow.
        :type: str
        """
        
        self._name = name

    @property
    def description(self):
        """
        Gets the description of this Flow.


        :return: The description of this Flow.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this Flow.


        :param description: The description of this Flow.
        :type: str
        """
        
        self._description = description

    @property
    def type(self):
        """
        Gets the type of this Flow.


        :return: The type of this Flow.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this Flow.


        :param type: The type of this Flow.
        :type: str
        """
        allowed_values = ["INBOUNDCALL", "OUTBOUNDCALL", "INQUEUECALL", "SPEECH", "SUBFLOWCALL"]
        if type not in allowed_values:
            raise ValueError(
                "Invalid value for `type`, must be one of {0}"
                .format(allowed_values)
            )

        self._type = type

    @property
    def locked_user(self):
        """
        Gets the locked_user of this Flow.


        :return: The locked_user of this Flow.
        :rtype: UriReference
        """
        return self._locked_user

    @locked_user.setter
    def locked_user(self, locked_user):
        """
        Sets the locked_user of this Flow.


        :param locked_user: The locked_user of this Flow.
        :type: UriReference
        """
        
        self._locked_user = locked_user

    @property
    def active(self):
        """
        Gets the active of this Flow.


        :return: The active of this Flow.
        :rtype: bool
        """
        return self._active

    @active.setter
    def active(self, active):
        """
        Sets the active of this Flow.


        :param active: The active of this Flow.
        :type: bool
        """
        
        self._active = active

    @property
    def deleted(self):
        """
        Gets the deleted of this Flow.


        :return: The deleted of this Flow.
        :rtype: bool
        """
        return self._deleted

    @deleted.setter
    def deleted(self, deleted):
        """
        Sets the deleted of this Flow.


        :param deleted: The deleted of this Flow.
        :type: bool
        """
        
        self._deleted = deleted

    @property
    def published_version(self):
        """
        Gets the published_version of this Flow.


        :return: The published_version of this Flow.
        :rtype: FlowVersion
        """
        return self._published_version

    @published_version.setter
    def published_version(self, published_version):
        """
        Sets the published_version of this Flow.


        :param published_version: The published_version of this Flow.
        :type: FlowVersion
        """
        
        self._published_version = published_version

    @property
    def checked_in_version(self):
        """
        Gets the checked_in_version of this Flow.


        :return: The checked_in_version of this Flow.
        :rtype: FlowVersion
        """
        return self._checked_in_version

    @checked_in_version.setter
    def checked_in_version(self, checked_in_version):
        """
        Sets the checked_in_version of this Flow.


        :param checked_in_version: The checked_in_version of this Flow.
        :type: FlowVersion
        """
        
        self._checked_in_version = checked_in_version

    @property
    def saved_version(self):
        """
        Gets the saved_version of this Flow.


        :return: The saved_version of this Flow.
        :rtype: FlowVersion
        """
        return self._saved_version

    @saved_version.setter
    def saved_version(self, saved_version):
        """
        Sets the saved_version of this Flow.


        :param saved_version: The saved_version of this Flow.
        :type: FlowVersion
        """
        
        self._saved_version = saved_version

    @property
    def system(self):
        """
        Gets the system of this Flow.


        :return: The system of this Flow.
        :rtype: bool
        """
        return self._system

    @system.setter
    def system(self, system):
        """
        Sets the system of this Flow.


        :param system: The system of this Flow.
        :type: bool
        """
        
        self._system = system

    @property
    def publish_status(self):
        """
        Gets the publish_status of this Flow.


        :return: The publish_status of this Flow.
        :rtype: str
        """
        return self._publish_status

    @publish_status.setter
    def publish_status(self, publish_status):
        """
        Sets the publish_status of this Flow.


        :param publish_status: The publish_status of this Flow.
        :type: str
        """
        allowed_values = ["STARTED", "PENDING_VXMLGEN", "PENDING_EDGE_CONFIG", "SUCCESS", "FAILURE"]
        if publish_status not in allowed_values:
            raise ValueError(
                "Invalid value for `publish_status`, must be one of {0}"
                .format(allowed_values)
            )

        self._publish_status = publish_status

    @property
    def published_by(self):
        """
        Gets the published_by of this Flow.


        :return: The published_by of this Flow.
        :rtype: UriReference
        """
        return self._published_by

    @published_by.setter
    def published_by(self, published_by):
        """
        Sets the published_by of this Flow.


        :param published_by: The published_by of this Flow.
        :type: UriReference
        """
        
        self._published_by = published_by

    @property
    def self_uri(self):
        """
        Gets the self_uri of this Flow.
        The URI for this object

        :return: The self_uri of this Flow.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri):
        """
        Sets the self_uri of this Flow.
        The URI for this object

        :param self_uri: The self_uri of this Flow.
        :type: str
        """
        
        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

