# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re


class FlowConfigMetaData(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        FlowConfigMetaData - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'config_state': 'str',
            'flow_type': 'str',
            'locked_by_user': 'User',
            'newest_published_version': 'str',
            'newest_version': 'str',
            'associated_workspaces': 'list[Workspace]',
            'description': 'str',
            'has_draft': 'bool',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'config_state': 'configState',
            'flow_type': 'flowType',
            'locked_by_user': 'lockedByUser',
            'newest_published_version': 'newestPublishedVersion',
            'newest_version': 'newestVersion',
            'associated_workspaces': 'associatedWorkspaces',
            'description': 'description',
            'has_draft': 'hasDraft',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._name = None
        self._config_state = None
        self._flow_type = None
        self._locked_by_user = None
        self._newest_published_version = None
        self._newest_version = None
        self._associated_workspaces = None
        self._description = None
        self._has_draft = False
        self._self_uri = None

    @property
    def id(self):
        """
        Gets the id of this FlowConfigMetaData.
        The globally unique identifier for the object.

        :return: The id of this FlowConfigMetaData.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this FlowConfigMetaData.
        The globally unique identifier for the object.

        :param id: The id of this FlowConfigMetaData.
        :type: str
        """
        
        self._id = id

    @property
    def name(self):
        """
        Gets the name of this FlowConfigMetaData.


        :return: The name of this FlowConfigMetaData.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this FlowConfigMetaData.


        :param name: The name of this FlowConfigMetaData.
        :type: str
        """
        
        self._name = name

    @property
    def config_state(self):
        """
        Gets the config_state of this FlowConfigMetaData.
        Usability of this flow definition. (output only)

        :return: The config_state of this FlowConfigMetaData.
        :rtype: str
        """
        return self._config_state

    @config_state.setter
    def config_state(self, config_state):
        """
        Sets the config_state of this FlowConfigMetaData.
        Usability of this flow definition. (output only)

        :param config_state: The config_state of this FlowConfigMetaData.
        :type: str
        """
        allowed_values = ["UNKNOWN", "ACTIVE", "INACTIVE", "DELETED"]
        if config_state not in allowed_values:
            raise ValueError(
                "Invalid value for `config_state`, must be one of {0}"
                .format(allowed_values)
            )

        self._config_state = config_state

    @property
    def flow_type(self):
        """
        Gets the flow_type of this FlowConfigMetaData.
        Type of flow this definition describes

        :return: The flow_type of this FlowConfigMetaData.
        :rtype: str
        """
        return self._flow_type

    @flow_type.setter
    def flow_type(self, flow_type):
        """
        Sets the flow_type of this FlowConfigMetaData.
        Type of flow this definition describes

        :param flow_type: The flow_type of this FlowConfigMetaData.
        :type: str
        """
        allowed_values = ["UNKNOWN", "WORKFLOW"]
        if flow_type not in allowed_values:
            raise ValueError(
                "Invalid value for `flow_type`, must be one of {0}"
                .format(allowed_values)
            )

        self._flow_type = flow_type

    @property
    def locked_by_user(self):
        """
        Gets the locked_by_user of this FlowConfigMetaData.
        If locked for editing, the user who locked this definition, otherwise null

        :return: The locked_by_user of this FlowConfigMetaData.
        :rtype: User
        """
        return self._locked_by_user

    @locked_by_user.setter
    def locked_by_user(self, locked_by_user):
        """
        Sets the locked_by_user of this FlowConfigMetaData.
        If locked for editing, the user who locked this definition, otherwise null

        :param locked_by_user: The locked_by_user of this FlowConfigMetaData.
        :type: User
        """
        
        self._locked_by_user = locked_by_user

    @property
    def newest_published_version(self):
        """
        Gets the newest_published_version of this FlowConfigMetaData.
        The most recently published version (output only)

        :return: The newest_published_version of this FlowConfigMetaData.
        :rtype: str
        """
        return self._newest_published_version

    @newest_published_version.setter
    def newest_published_version(self, newest_published_version):
        """
        Sets the newest_published_version of this FlowConfigMetaData.
        The most recently published version (output only)

        :param newest_published_version: The newest_published_version of this FlowConfigMetaData.
        :type: str
        """
        
        self._newest_published_version = newest_published_version

    @property
    def newest_version(self):
        """
        Gets the newest_version of this FlowConfigMetaData.
        The most recent version, regardless of published state (output only)

        :return: The newest_version of this FlowConfigMetaData.
        :rtype: str
        """
        return self._newest_version

    @newest_version.setter
    def newest_version(self, newest_version):
        """
        Sets the newest_version of this FlowConfigMetaData.
        The most recent version, regardless of published state (output only)

        :param newest_version: The newest_version of this FlowConfigMetaData.
        :type: str
        """
        
        self._newest_version = newest_version

    @property
    def associated_workspaces(self):
        """
        Gets the associated_workspaces of this FlowConfigMetaData.
        Workspaces associated with this flow.

        :return: The associated_workspaces of this FlowConfigMetaData.
        :rtype: list[Workspace]
        """
        return self._associated_workspaces

    @associated_workspaces.setter
    def associated_workspaces(self, associated_workspaces):
        """
        Sets the associated_workspaces of this FlowConfigMetaData.
        Workspaces associated with this flow.

        :param associated_workspaces: The associated_workspaces of this FlowConfigMetaData.
        :type: list[Workspace]
        """
        
        self._associated_workspaces = associated_workspaces

    @property
    def description(self):
        """
        Gets the description of this FlowConfigMetaData.
        User notes describing the flow definition.

        :return: The description of this FlowConfigMetaData.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this FlowConfigMetaData.
        User notes describing the flow definition.

        :param description: The description of this FlowConfigMetaData.
        :type: str
        """
        
        self._description = description

    @property
    def has_draft(self):
        """
        Gets the has_draft of this FlowConfigMetaData.
        Flag if this definition has a draft populated.

        :return: The has_draft of this FlowConfigMetaData.
        :rtype: bool
        """
        return self._has_draft

    @has_draft.setter
    def has_draft(self, has_draft):
        """
        Sets the has_draft of this FlowConfigMetaData.
        Flag if this definition has a draft populated.

        :param has_draft: The has_draft of this FlowConfigMetaData.
        :type: bool
        """
        
        self._has_draft = has_draft

    @property
    def self_uri(self):
        """
        Gets the self_uri of this FlowConfigMetaData.
        The URI for this object

        :return: The self_uri of this FlowConfigMetaData.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri):
        """
        Sets the self_uri of this FlowConfigMetaData.
        The URI for this object

        :param self_uri: The self_uri of this FlowConfigMetaData.
        :type: str
        """
        
        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

