# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re


class FlowDetails(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        FlowDetails - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'flow_config_id': 'FlowConfigId',
            'launch_time': 'datetime',
            'launch_type': 'str',
            'launched_by': 'User',
            'status': 'str',
            'associated_documents': 'list[AssociatedDocument]',
            'flow_completion_time': 'datetime',
            'flow_completion_reason': 'str',
            'flow_error_info': 'ErrorBody',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'flow_config_id': 'flowConfigId',
            'launch_time': 'launchTime',
            'launch_type': 'launchType',
            'launched_by': 'launchedBy',
            'status': 'status',
            'associated_documents': 'associatedDocuments',
            'flow_completion_time': 'flowCompletionTime',
            'flow_completion_reason': 'flowCompletionReason',
            'flow_error_info': 'flowErrorInfo',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._name = None
        self._flow_config_id = None
        self._launch_time = None
        self._launch_type = None
        self._launched_by = None
        self._status = None
        self._associated_documents = None
        self._flow_completion_time = None
        self._flow_completion_reason = None
        self._flow_error_info = None
        self._self_uri = None

    @property
    def id(self):
        """
        Gets the id of this FlowDetails.
        The globally unique identifier for the object.

        :return: The id of this FlowDetails.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this FlowDetails.
        The globally unique identifier for the object.

        :param id: The id of this FlowDetails.
        :type: str
        """
        
        self._id = id

    @property
    def name(self):
        """
        Gets the name of this FlowDetails.


        :return: The name of this FlowDetails.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this FlowDetails.


        :param name: The name of this FlowDetails.
        :type: str
        """
        
        self._name = name

    @property
    def flow_config_id(self):
        """
        Gets the flow_config_id of this FlowDetails.
        The FlowConfigId that was used to launch this flow.

        :return: The flow_config_id of this FlowDetails.
        :rtype: FlowConfigId
        """
        return self._flow_config_id

    @flow_config_id.setter
    def flow_config_id(self, flow_config_id):
        """
        Sets the flow_config_id of this FlowDetails.
        The FlowConfigId that was used to launch this flow.

        :param flow_config_id: The flow_config_id of this FlowDetails.
        :type: FlowConfigId
        """
        
        self._flow_config_id = flow_config_id

    @property
    def launch_time(self):
        """
        Gets the launch_time of this FlowDetails.
        The time the flow was launched. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :return: The launch_time of this FlowDetails.
        :rtype: datetime
        """
        return self._launch_time

    @launch_time.setter
    def launch_time(self, launch_time):
        """
        Sets the launch_time of this FlowDetails.
        The time the flow was launched. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :param launch_time: The launch_time of this FlowDetails.
        :type: datetime
        """
        
        self._launch_time = launch_time

    @property
    def launch_type(self):
        """
        Gets the launch_type of this FlowDetails.
        The launch mode for this flow instance.

        :return: The launch_type of this FlowDetails.
        :rtype: str
        """
        return self._launch_type

    @launch_type.setter
    def launch_type(self, launch_type):
        """
        Sets the launch_type of this FlowDetails.
        The launch mode for this flow instance.

        :param launch_type: The launch_type of this FlowDetails.
        :type: str
        """
        allowed_values = ["UNKNOWN", "NORMAL", "TEST", "AUTOMATIC"]
        if launch_type not in allowed_values:
            raise ValueError(
                "Invalid value for `launch_type`, must be one of {0}"
                .format(allowed_values)
            )

        self._launch_type = launch_type

    @property
    def launched_by(self):
        """
        Gets the launched_by of this FlowDetails.
        The user who launched the flow, if the flow was launched as the result of that user's action.

        :return: The launched_by of this FlowDetails.
        :rtype: User
        """
        return self._launched_by

    @launched_by.setter
    def launched_by(self, launched_by):
        """
        Sets the launched_by of this FlowDetails.
        The user who launched the flow, if the flow was launched as the result of that user's action.

        :param launched_by: The launched_by of this FlowDetails.
        :type: User
        """
        
        self._launched_by = launched_by

    @property
    def status(self):
        """
        Gets the status of this FlowDetails.
        The flow's running status, which indicates whether the flow is running normally or completed, etc.

        :return: The status of this FlowDetails.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """
        Sets the status of this FlowDetails.
        The flow's running status, which indicates whether the flow is running normally or completed, etc.

        :param status: The status of this FlowDetails.
        :type: str
        """
        allowed_values = ["UNKNOWN", "RUNNING", "ERROR", "TERMINATED", "COMPLETED"]
        if status not in allowed_values:
            raise ValueError(
                "Invalid value for `status`, must be one of {0}"
                .format(allowed_values)
            )

        self._status = status

    @property
    def associated_documents(self):
        """
        Gets the associated_documents of this FlowDetails.
        The documents associated with this flow.

        :return: The associated_documents of this FlowDetails.
        :rtype: list[AssociatedDocument]
        """
        return self._associated_documents

    @associated_documents.setter
    def associated_documents(self, associated_documents):
        """
        Sets the associated_documents of this FlowDetails.
        The documents associated with this flow.

        :param associated_documents: The associated_documents of this FlowDetails.
        :type: list[AssociatedDocument]
        """
        
        self._associated_documents = associated_documents

    @property
    def flow_completion_time(self):
        """
        Gets the flow_completion_time of this FlowDetails.
        The time the flow completed, if applicable. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :return: The flow_completion_time of this FlowDetails.
        :rtype: datetime
        """
        return self._flow_completion_time

    @flow_completion_time.setter
    def flow_completion_time(self, flow_completion_time):
        """
        Sets the flow_completion_time of this FlowDetails.
        The time the flow completed, if applicable. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :param flow_completion_time: The flow_completion_time of this FlowDetails.
        :type: datetime
        """
        
        self._flow_completion_time = flow_completion_time

    @property
    def flow_completion_reason(self):
        """
        Gets the flow_completion_reason of this FlowDetails.
        The completion reason set at the flow completion time, if applicable.

        :return: The flow_completion_reason of this FlowDetails.
        :rtype: str
        """
        return self._flow_completion_reason

    @flow_completion_reason.setter
    def flow_completion_reason(self, flow_completion_reason):
        """
        Sets the flow_completion_reason of this FlowDetails.
        The completion reason set at the flow completion time, if applicable.

        :param flow_completion_reason: The flow_completion_reason of this FlowDetails.
        :type: str
        """
        
        self._flow_completion_reason = flow_completion_reason

    @property
    def flow_error_info(self):
        """
        Gets the flow_error_info of this FlowDetails.
        Additional information if the flow is in error

        :return: The flow_error_info of this FlowDetails.
        :rtype: ErrorBody
        """
        return self._flow_error_info

    @flow_error_info.setter
    def flow_error_info(self, flow_error_info):
        """
        Sets the flow_error_info of this FlowDetails.
        Additional information if the flow is in error

        :param flow_error_info: The flow_error_info of this FlowDetails.
        :type: ErrorBody
        """
        
        self._flow_error_info = flow_error_info

    @property
    def self_uri(self):
        """
        Gets the self_uri of this FlowDetails.
        The URI for this object

        :return: The self_uri of this FlowDetails.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri):
        """
        Sets the self_uri of this FlowDetails.
        The URI for this object

        :param self_uri: The self_uri of this FlowDetails.
        :type: str
        """
        
        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

