# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re


class FlowDetailsSearchResult(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        FlowDetailsSearchResult - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'search_results': 'LinkedEntityListingFlowDetails',
            'facet_results': 'list[FacetResult]'
        }

        self.attribute_map = {
            'search_results': 'searchResults',
            'facet_results': 'facetResults'
        }

        self._search_results = None
        self._facet_results = None

    @property
    def search_results(self):
        """
        Gets the search_results of this FlowDetailsSearchResult.
        The actual results from the search

        :return: The search_results of this FlowDetailsSearchResult.
        :rtype: LinkedEntityListingFlowDetails
        """
        return self._search_results

    @search_results.setter
    def search_results(self, search_results):
        """
        Sets the search_results of this FlowDetailsSearchResult.
        The actual results from the search

        :param search_results: The search_results of this FlowDetailsSearchResult.
        :type: LinkedEntityListingFlowDetails
        """
        
        self._search_results = search_results

    @property
    def facet_results(self):
        """
        Gets the facet_results of this FlowDetailsSearchResult.
        The results from the facet requests for this search - note ALL facets will always be returned regardless of page size/starting pagenumber in the searchRequest

        :return: The facet_results of this FlowDetailsSearchResult.
        :rtype: list[FacetResult]
        """
        return self._facet_results

    @facet_results.setter
    def facet_results(self, facet_results):
        """
        Sets the facet_results of this FlowDetailsSearchResult.
        The results from the facet requests for this search - note ALL facets will always be returned regardless of page size/starting pagenumber in the searchRequest

        :param facet_results: The facet_results of this FlowDetailsSearchResult.
        :type: list[FacetResult]
        """
        
        self._facet_results = facet_results

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

