# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re


class FlowHistoryDataItem(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        FlowHistoryDataItem - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'parameter_name': 'str',
            'parameter_type': 'str',
            'parameter_values': 'Value'
        }

        self.attribute_map = {
            'parameter_name': 'parameterName',
            'parameter_type': 'parameterType',
            'parameter_values': 'parameterValues'
        }

        self._parameter_name = None
        self._parameter_type = None
        self._parameter_values = None

    @property
    def parameter_name(self):
        """
        Gets the parameter_name of this FlowHistoryDataItem.
        The name of the data element associated with a history event.

        :return: The parameter_name of this FlowHistoryDataItem.
        :rtype: str
        """
        return self._parameter_name

    @parameter_name.setter
    def parameter_name(self, parameter_name):
        """
        Sets the parameter_name of this FlowHistoryDataItem.
        The name of the data element associated with a history event.

        :param parameter_name: The parameter_name of this FlowHistoryDataItem.
        :type: str
        """
        
        self._parameter_name = parameter_name

    @property
    def parameter_type(self):
        """
        Gets the parameter_type of this FlowHistoryDataItem.
        The type of the data element associated with a history event.

        :return: The parameter_type of this FlowHistoryDataItem.
        :rtype: str
        """
        return self._parameter_type

    @parameter_type.setter
    def parameter_type(self, parameter_type):
        """
        Sets the parameter_type of this FlowHistoryDataItem.
        The type of the data element associated with a history event.

        :param parameter_type: The parameter_type of this FlowHistoryDataItem.
        :type: str
        """
        
        self._parameter_type = parameter_type

    @property
    def parameter_values(self):
        """
        Gets the parameter_values of this FlowHistoryDataItem.
        The values of the data element associated with a history event.

        :return: The parameter_values of this FlowHistoryDataItem.
        :rtype: Value
        """
        return self._parameter_values

    @parameter_values.setter
    def parameter_values(self, parameter_values):
        """
        Sets the parameter_values of this FlowHistoryDataItem.
        The values of the data element associated with a history event.

        :param parameter_values: The parameter_values of this FlowHistoryDataItem.
        :type: Value
        """
        
        self._parameter_values = parameter_values

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

