# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re


class FlowHistoryItem(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        FlowHistoryItem - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'history_event_time': 'datetime',
            'state': 'FlowState',
            'work_item': 'WorkItem',
            'user': 'User',
            'queue': 'Queue',
            'history_event_data': 'list[FlowHistoryDataItem]',
            'history_event_type': 'str',
            'success': 'bool'
        }

        self.attribute_map = {
            'history_event_time': 'historyEventTime',
            'state': 'state',
            'work_item': 'workItem',
            'user': 'user',
            'queue': 'queue',
            'history_event_data': 'historyEventData',
            'history_event_type': 'historyEventType',
            'success': 'success'
        }

        self._history_event_time = None
        self._state = None
        self._work_item = None
        self._user = None
        self._queue = None
        self._history_event_data = None
        self._history_event_type = None
        self._success = False

    @property
    def history_event_time(self):
        """
        Gets the history_event_time of this FlowHistoryItem.
        The time when the history item occurred. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :return: The history_event_time of this FlowHistoryItem.
        :rtype: datetime
        """
        return self._history_event_time

    @history_event_time.setter
    def history_event_time(self, history_event_time):
        """
        Sets the history_event_time of this FlowHistoryItem.
        The time when the history item occurred. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :param history_event_time: The history_event_time of this FlowHistoryItem.
        :type: datetime
        """
        
        self._history_event_time = history_event_time

    @property
    def state(self):
        """
        Gets the state of this FlowHistoryItem.
        The State sequence that applies to the history event, if applicable.

        :return: The state of this FlowHistoryItem.
        :rtype: FlowState
        """
        return self._state

    @state.setter
    def state(self, state):
        """
        Sets the state of this FlowHistoryItem.
        The State sequence that applies to the history event, if applicable.

        :param state: The state of this FlowHistoryItem.
        :type: FlowState
        """
        
        self._state = state

    @property
    def work_item(self):
        """
        Gets the work_item of this FlowHistoryItem.
        Information about the work item associated with the history event, if applicable.

        :return: The work_item of this FlowHistoryItem.
        :rtype: WorkItem
        """
        return self._work_item

    @work_item.setter
    def work_item(self, work_item):
        """
        Sets the work_item of this FlowHistoryItem.
        Information about the work item associated with the history event, if applicable.

        :param work_item: The work_item of this FlowHistoryItem.
        :type: WorkItem
        """
        
        self._work_item = work_item

    @property
    def user(self):
        """
        Gets the user of this FlowHistoryItem.
        The user associated with this history event, if applicable.

        :return: The user of this FlowHistoryItem.
        :rtype: User
        """
        return self._user

    @user.setter
    def user(self, user):
        """
        Sets the user of this FlowHistoryItem.
        The user associated with this history event, if applicable.

        :param user: The user of this FlowHistoryItem.
        :type: User
        """
        
        self._user = user

    @property
    def queue(self):
        """
        Gets the queue of this FlowHistoryItem.
        The queue associated with this history event, if applicable.

        :return: The queue of this FlowHistoryItem.
        :rtype: Queue
        """
        return self._queue

    @queue.setter
    def queue(self, queue):
        """
        Sets the queue of this FlowHistoryItem.
        The queue associated with this history event, if applicable.

        :param queue: The queue of this FlowHistoryItem.
        :type: Queue
        """
        
        self._queue = queue

    @property
    def history_event_data(self):
        """
        Gets the history_event_data of this FlowHistoryItem.
        Data elements associated with this history event.

        :return: The history_event_data of this FlowHistoryItem.
        :rtype: list[FlowHistoryDataItem]
        """
        return self._history_event_data

    @history_event_data.setter
    def history_event_data(self, history_event_data):
        """
        Sets the history_event_data of this FlowHistoryItem.
        Data elements associated with this history event.

        :param history_event_data: The history_event_data of this FlowHistoryItem.
        :type: list[FlowHistoryDataItem]
        """
        
        self._history_event_data = history_event_data

    @property
    def history_event_type(self):
        """
        Gets the history_event_type of this FlowHistoryItem.
        The type of the history event being reported.

        :return: The history_event_type of this FlowHistoryItem.
        :rtype: str
        """
        return self._history_event_type

    @history_event_type.setter
    def history_event_type(self, history_event_type):
        """
        Sets the history_event_type of this FlowHistoryItem.
        The type of the history event being reported.

        :param history_event_type: The history_event_type of this FlowHistoryItem.
        :type: str
        """
        allowed_values = ["FLOW_INSTANCE_START", "FLOW_INSTANCE_GOTO", "FLOW_INSTANCE_TERMINATE", "FLOW_INSTANCE_END", "TASK_INSTANCE_START", "TASK_INSTANCE_END", "WORK_ITEM_INSTANCE_SAVE", "WORK_ITEM_INSTANCE_ACQUIRE", "WORK_ITEM_INSTANCE_SUBMIT", "WORK_ITEM_INSTANCE_OFFER", "WORK_ITEM_INSTANCE_REASSIGN", "FLOW_INSTANCE_ERROR", "FLOW_INSTANCE_RETRY"]
        if history_event_type not in allowed_values:
            raise ValueError(
                "Invalid value for `history_event_type`, must be one of {0}"
                .format(allowed_values)
            )

        self._history_event_type = history_event_type

    @property
    def success(self):
        """
        Gets the success of this FlowHistoryItem.
        Whether or not the flow item was successful (if a 'notification' event this will default to true)

        :return: The success of this FlowHistoryItem.
        :rtype: bool
        """
        return self._success

    @success.setter
    def success(self, success):
        """
        Sets the success of this FlowHistoryItem.
        Whether or not the flow item was successful (if a 'notification' event this will default to true)

        :param success: The success of this FlowHistoryItem.
        :type: bool
        """
        
        self._success = success

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

