# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re


class FlowHistoryResultItem(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        FlowHistoryResultItem - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'flow_instance': 'FlowDetails',
            'available_actions': 'BackendFlowAvailableActions',
            'history_items': 'list[FlowHistoryItem]'
        }

        self.attribute_map = {
            'flow_instance': 'flowInstance',
            'available_actions': 'availableActions',
            'history_items': 'historyItems'
        }

        self._flow_instance = None
        self._available_actions = None
        self._history_items = None

    @property
    def flow_instance(self):
        """
        Gets the flow_instance of this FlowHistoryResultItem.
        The flow instance information that applies to the history events.

        :return: The flow_instance of this FlowHistoryResultItem.
        :rtype: FlowDetails
        """
        return self._flow_instance

    @flow_instance.setter
    def flow_instance(self, flow_instance):
        """
        Sets the flow_instance of this FlowHistoryResultItem.
        The flow instance information that applies to the history events.

        :param flow_instance: The flow_instance of this FlowHistoryResultItem.
        :type: FlowDetails
        """
        
        self._flow_instance = flow_instance

    @property
    def available_actions(self):
        """
        Gets the available_actions of this FlowHistoryResultItem.
        The actions available for operating in the flow, with respect to your authorization identity.

        :return: The available_actions of this FlowHistoryResultItem.
        :rtype: BackendFlowAvailableActions
        """
        return self._available_actions

    @available_actions.setter
    def available_actions(self, available_actions):
        """
        Sets the available_actions of this FlowHistoryResultItem.
        The actions available for operating in the flow, with respect to your authorization identity.

        :param available_actions: The available_actions of this FlowHistoryResultItem.
        :type: BackendFlowAvailableActions
        """
        
        self._available_actions = available_actions

    @property
    def history_items(self):
        """
        Gets the history_items of this FlowHistoryResultItem.
        The ordered list of history events for this flow.

        :return: The history_items of this FlowHistoryResultItem.
        :rtype: list[FlowHistoryItem]
        """
        return self._history_items

    @history_items.setter
    def history_items(self, history_items):
        """
        Sets the history_items of this FlowHistoryResultItem.
        The ordered list of history events for this flow.

        :param history_items: The history_items of this FlowHistoryResultItem.
        :type: list[FlowHistoryItem]
        """
        
        self._history_items = history_items

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

