# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re


class FlowLaunchRequest(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        FlowLaunchRequest - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'flow_config_id': 'FlowConfigId',
            'flow_instance_name': 'str',
            'input_data': 'FlowInputData',
            'launch_type': 'str'
        }

        self.attribute_map = {
            'flow_config_id': 'flowConfigId',
            'flow_instance_name': 'flowInstanceName',
            'input_data': 'inputData',
            'launch_type': 'launchType'
        }

        self._flow_config_id = None
        self._flow_instance_name = None
        self._input_data = None
        self._launch_type = None

    @property
    def flow_config_id(self):
        """
        Gets the flow_config_id of this FlowLaunchRequest.
        ID of the flow to launch, will launch the most recently published version if a specific version is not specified.

        :return: The flow_config_id of this FlowLaunchRequest.
        :rtype: FlowConfigId
        """
        return self._flow_config_id

    @flow_config_id.setter
    def flow_config_id(self, flow_config_id):
        """
        Sets the flow_config_id of this FlowLaunchRequest.
        ID of the flow to launch, will launch the most recently published version if a specific version is not specified.

        :param flow_config_id: The flow_config_id of this FlowLaunchRequest.
        :type: FlowConfigId
        """
        
        self._flow_config_id = flow_config_id

    @property
    def flow_instance_name(self):
        """
        Gets the flow_instance_name of this FlowLaunchRequest.
        The displayable instance name to assign to the new flow instance (or omit to have one automatically generated)

        :return: The flow_instance_name of this FlowLaunchRequest.
        :rtype: str
        """
        return self._flow_instance_name

    @flow_instance_name.setter
    def flow_instance_name(self, flow_instance_name):
        """
        Sets the flow_instance_name of this FlowLaunchRequest.
        The displayable instance name to assign to the new flow instance (or omit to have one automatically generated)

        :param flow_instance_name: The flow_instance_name of this FlowLaunchRequest.
        :type: str
        """
        
        self._flow_instance_name = flow_instance_name

    @property
    def input_data(self):
        """
        Gets the input_data of this FlowLaunchRequest.
        contains launch parameters or initializations for variables in the flow.

        :return: The input_data of this FlowLaunchRequest.
        :rtype: FlowInputData
        """
        return self._input_data

    @input_data.setter
    def input_data(self, input_data):
        """
        Sets the input_data of this FlowLaunchRequest.
        contains launch parameters or initializations for variables in the flow.

        :param input_data: The input_data of this FlowLaunchRequest.
        :type: FlowInputData
        """
        
        self._input_data = input_data

    @property
    def launch_type(self):
        """
        Gets the launch_type of this FlowLaunchRequest.
        launch type of the flow - NORMAL or TEST

        :return: The launch_type of this FlowLaunchRequest.
        :rtype: str
        """
        return self._launch_type

    @launch_type.setter
    def launch_type(self, launch_type):
        """
        Sets the launch_type of this FlowLaunchRequest.
        launch type of the flow - NORMAL or TEST

        :param launch_type: The launch_type of this FlowLaunchRequest.
        :type: str
        """
        allowed_values = ["UNKNOWN", "NORMAL", "TEST", "AUTOMATIC"]
        if launch_type not in allowed_values:
            raise ValueError(
                "Invalid value for `launch_type`, must be one of {0}"
                .format(allowed_values)
            )

        self._launch_type = launch_type

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

