# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re


class FlowReportResultItem(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        FlowReportResultItem - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'flow_exec_id': 'FlowExecId',
            'flow_config_id': 'FlowConfigId',
            'flow_instance_name': 'str',
            'associated_document': 'AssociatedDocument',
            'flow_status': 'str',
            'current_state': 'str',
            'start_date_time': 'datetime',
            'end_date_time': 'datetime',
            'work_item_user_assignees': 'list[User]',
            'completed_user': 'User',
            'completion_reason': 'str',
            'flow_error_info': 'ErrorBody'
        }

        self.attribute_map = {
            'flow_exec_id': 'flowExecId',
            'flow_config_id': 'flowConfigId',
            'flow_instance_name': 'flowInstanceName',
            'associated_document': 'associatedDocument',
            'flow_status': 'flowStatus',
            'current_state': 'currentState',
            'start_date_time': 'startDateTime',
            'end_date_time': 'endDateTime',
            'work_item_user_assignees': 'workItemUserAssignees',
            'completed_user': 'completedUser',
            'completion_reason': 'completionReason',
            'flow_error_info': 'flowErrorInfo'
        }

        self._flow_exec_id = None
        self._flow_config_id = None
        self._flow_instance_name = None
        self._associated_document = None
        self._flow_status = None
        self._current_state = None
        self._start_date_time = None
        self._end_date_time = None
        self._work_item_user_assignees = None
        self._completed_user = None
        self._completion_reason = None
        self._flow_error_info = None

    @property
    def flow_exec_id(self):
        """
        Gets the flow_exec_id of this FlowReportResultItem.
        The flow instance ID for this process

        :return: The flow_exec_id of this FlowReportResultItem.
        :rtype: FlowExecId
        """
        return self._flow_exec_id

    @flow_exec_id.setter
    def flow_exec_id(self, flow_exec_id):
        """
        Sets the flow_exec_id of this FlowReportResultItem.
        The flow instance ID for this process

        :param flow_exec_id: The flow_exec_id of this FlowReportResultItem.
        :type: FlowExecId
        """
        
        self._flow_exec_id = flow_exec_id

    @property
    def flow_config_id(self):
        """
        Gets the flow_config_id of this FlowReportResultItem.
        The flow config ID that this workitem was created from.

        :return: The flow_config_id of this FlowReportResultItem.
        :rtype: FlowConfigId
        """
        return self._flow_config_id

    @flow_config_id.setter
    def flow_config_id(self, flow_config_id):
        """
        Sets the flow_config_id of this FlowReportResultItem.
        The flow config ID that this workitem was created from.

        :param flow_config_id: The flow_config_id of this FlowReportResultItem.
        :type: FlowConfigId
        """
        
        self._flow_config_id = flow_config_id

    @property
    def flow_instance_name(self):
        """
        Gets the flow_instance_name of this FlowReportResultItem.
        The instance name for this flow in relation to its primary document.  If the flow is not a document-centric type, this value will be empty.

        :return: The flow_instance_name of this FlowReportResultItem.
        :rtype: str
        """
        return self._flow_instance_name

    @flow_instance_name.setter
    def flow_instance_name(self, flow_instance_name):
        """
        Sets the flow_instance_name of this FlowReportResultItem.
        The instance name for this flow in relation to its primary document.  If the flow is not a document-centric type, this value will be empty.

        :param flow_instance_name: The flow_instance_name of this FlowReportResultItem.
        :type: str
        """
        
        self._flow_instance_name = flow_instance_name

    @property
    def associated_document(self):
        """
        Gets the associated_document of this FlowReportResultItem.
        the document for this flow (if this flow was launched via a document)

        :return: The associated_document of this FlowReportResultItem.
        :rtype: AssociatedDocument
        """
        return self._associated_document

    @associated_document.setter
    def associated_document(self, associated_document):
        """
        Sets the associated_document of this FlowReportResultItem.
        the document for this flow (if this flow was launched via a document)

        :param associated_document: The associated_document of this FlowReportResultItem.
        :type: AssociatedDocument
        """
        
        self._associated_document = associated_document

    @property
    def flow_status(self):
        """
        Gets the flow_status of this FlowReportResultItem.
        The flow's running status, which indicates whether the flow is running normally or in error, etc;

        :return: The flow_status of this FlowReportResultItem.
        :rtype: str
        """
        return self._flow_status

    @flow_status.setter
    def flow_status(self, flow_status):
        """
        Sets the flow_status of this FlowReportResultItem.
        The flow's running status, which indicates whether the flow is running normally or in error, etc;

        :param flow_status: The flow_status of this FlowReportResultItem.
        :type: str
        """
        allowed_values = ["UNKNOWN", "RUNNING", "ERROR", "TERMINATED", "COMPLETED"]
        if flow_status not in allowed_values:
            raise ValueError(
                "Invalid value for `flow_status`, must be one of {0}"
                .format(allowed_values)
            )

        self._flow_status = flow_status

    @property
    def current_state(self):
        """
        Gets the current_state of this FlowReportResultItem.
        The current state of the flow (EG what action is being processed)

        :return: The current_state of this FlowReportResultItem.
        :rtype: str
        """
        return self._current_state

    @current_state.setter
    def current_state(self, current_state):
        """
        Sets the current_state of this FlowReportResultItem.
        The current state of the flow (EG what action is being processed)

        :param current_state: The current_state of this FlowReportResultItem.
        :type: str
        """
        
        self._current_state = current_state

    @property
    def start_date_time(self):
        """
        Gets the start_date_time of this FlowReportResultItem.
        The time the flow was started. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :return: The start_date_time of this FlowReportResultItem.
        :rtype: datetime
        """
        return self._start_date_time

    @start_date_time.setter
    def start_date_time(self, start_date_time):
        """
        Sets the start_date_time of this FlowReportResultItem.
        The time the flow was started. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :param start_date_time: The start_date_time of this FlowReportResultItem.
        :type: datetime
        """
        
        self._start_date_time = start_date_time

    @property
    def end_date_time(self):
        """
        Gets the end_date_time of this FlowReportResultItem.
        The time the flow ended. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :return: The end_date_time of this FlowReportResultItem.
        :rtype: datetime
        """
        return self._end_date_time

    @end_date_time.setter
    def end_date_time(self, end_date_time):
        """
        Sets the end_date_time of this FlowReportResultItem.
        The time the flow ended. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :param end_date_time: The end_date_time of this FlowReportResultItem.
        :type: datetime
        """
        
        self._end_date_time = end_date_time

    @property
    def work_item_user_assignees(self):
        """
        Gets the work_item_user_assignees of this FlowReportResultItem.
        List of users currently assigned to a workItem

        :return: The work_item_user_assignees of this FlowReportResultItem.
        :rtype: list[User]
        """
        return self._work_item_user_assignees

    @work_item_user_assignees.setter
    def work_item_user_assignees(self, work_item_user_assignees):
        """
        Sets the work_item_user_assignees of this FlowReportResultItem.
        List of users currently assigned to a workItem

        :param work_item_user_assignees: The work_item_user_assignees of this FlowReportResultItem.
        :type: list[User]
        """
        
        self._work_item_user_assignees = work_item_user_assignees

    @property
    def completed_user(self):
        """
        Gets the completed_user of this FlowReportResultItem.
        User that completed the flow

        :return: The completed_user of this FlowReportResultItem.
        :rtype: User
        """
        return self._completed_user

    @completed_user.setter
    def completed_user(self, completed_user):
        """
        Sets the completed_user of this FlowReportResultItem.
        User that completed the flow

        :param completed_user: The completed_user of this FlowReportResultItem.
        :type: User
        """
        
        self._completed_user = completed_user

    @property
    def completion_reason(self):
        """
        Gets the completion_reason of this FlowReportResultItem.
        Reason for completion

        :return: The completion_reason of this FlowReportResultItem.
        :rtype: str
        """
        return self._completion_reason

    @completion_reason.setter
    def completion_reason(self, completion_reason):
        """
        Sets the completion_reason of this FlowReportResultItem.
        Reason for completion

        :param completion_reason: The completion_reason of this FlowReportResultItem.
        :type: str
        """
        
        self._completion_reason = completion_reason

    @property
    def flow_error_info(self):
        """
        Gets the flow_error_info of this FlowReportResultItem.
        Additional information if the flow is in error

        :return: The flow_error_info of this FlowReportResultItem.
        :rtype: ErrorBody
        """
        return self._flow_error_info

    @flow_error_info.setter
    def flow_error_info(self, flow_error_info):
        """
        Sets the flow_error_info of this FlowReportResultItem.
        Additional information if the flow is in error

        :param flow_error_info: The flow_error_info of this FlowReportResultItem.
        :type: ErrorBody
        """
        
        self._flow_error_info = flow_error_info

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

