# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re


class FlowUploadResponse(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        FlowUploadResponse - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'uri': 'str',
            'upload_token': 'str'
        }

        self.attribute_map = {
            'uri': 'uri',
            'upload_token': 'uploadToken'
        }

        self._uri = None
        self._upload_token = None

    @property
    def uri(self):
        """
        Gets the uri of this FlowUploadResponse.
        uri destination to upload file to

        :return: The uri of this FlowUploadResponse.
        :rtype: str
        """
        return self._uri

    @uri.setter
    def uri(self, uri):
        """
        Sets the uri of this FlowUploadResponse.
        uri destination to upload file to

        :param uri: The uri of this FlowUploadResponse.
        :type: str
        """
        
        self._uri = uri

    @property
    def upload_token(self):
        """
        Gets the upload_token of this FlowUploadResponse.
        token to send along when creating versioned flow so the file can be bound to the metadata

        :return: The upload_token of this FlowUploadResponse.
        :rtype: str
        """
        return self._upload_token

    @upload_token.setter
    def upload_token(self, upload_token):
        """
        Sets the upload_token of this FlowUploadResponse.
        token to send along when creating versioned flow so the file can be bound to the metadata

        :param upload_token: The upload_token of this FlowUploadResponse.
        :type: str
        """
        
        self._upload_token = upload_token

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

