# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re


class FlowVersionConfigMetaData(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        FlowVersionConfigMetaData - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'version_specific_comment': 'str',
            'flow_definition_uri': 'str',
            'created_by_user': 'User',
            'created_date': 'datetime',
            'self_uri': 'str',
            'version': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'version_specific_comment': 'versionSpecificComment',
            'flow_definition_uri': 'flowDefinitionUri',
            'created_by_user': 'createdByUser',
            'created_date': 'createdDate',
            'self_uri': 'selfUri',
            'version': 'version'
        }

        self._id = None
        self._name = None
        self._version_specific_comment = None
        self._flow_definition_uri = None
        self._created_by_user = None
        self._created_date = None
        self._self_uri = None
        self._version = None

    @property
    def id(self):
        """
        Gets the id of this FlowVersionConfigMetaData.
        The globally unique identifier for the object.

        :return: The id of this FlowVersionConfigMetaData.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this FlowVersionConfigMetaData.
        The globally unique identifier for the object.

        :param id: The id of this FlowVersionConfigMetaData.
        :type: str
        """
        
        self._id = id

    @property
    def name(self):
        """
        Gets the name of this FlowVersionConfigMetaData.


        :return: The name of this FlowVersionConfigMetaData.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this FlowVersionConfigMetaData.


        :param name: The name of this FlowVersionConfigMetaData.
        :type: str
        """
        
        self._name = name

    @property
    def version_specific_comment(self):
        """
        Gets the version_specific_comment of this FlowVersionConfigMetaData.
        Checkin comment for this specific flow version.

        :return: The version_specific_comment of this FlowVersionConfigMetaData.
        :rtype: str
        """
        return self._version_specific_comment

    @version_specific_comment.setter
    def version_specific_comment(self, version_specific_comment):
        """
        Sets the version_specific_comment of this FlowVersionConfigMetaData.
        Checkin comment for this specific flow version.

        :param version_specific_comment: The version_specific_comment of this FlowVersionConfigMetaData.
        :type: str
        """
        
        self._version_specific_comment = version_specific_comment

    @property
    def flow_definition_uri(self):
        """
        Gets the flow_definition_uri of this FlowVersionConfigMetaData.
        Uri location for the flow definition contents.

        :return: The flow_definition_uri of this FlowVersionConfigMetaData.
        :rtype: str
        """
        return self._flow_definition_uri

    @flow_definition_uri.setter
    def flow_definition_uri(self, flow_definition_uri):
        """
        Sets the flow_definition_uri of this FlowVersionConfigMetaData.
        Uri location for the flow definition contents.

        :param flow_definition_uri: The flow_definition_uri of this FlowVersionConfigMetaData.
        :type: str
        """
        
        self._flow_definition_uri = flow_definition_uri

    @property
    def created_by_user(self):
        """
        Gets the created_by_user of this FlowVersionConfigMetaData.
        If known, the user who created this flow version.

        :return: The created_by_user of this FlowVersionConfigMetaData.
        :rtype: User
        """
        return self._created_by_user

    @created_by_user.setter
    def created_by_user(self, created_by_user):
        """
        Sets the created_by_user of this FlowVersionConfigMetaData.
        If known, the user who created this flow version.

        :param created_by_user: The created_by_user of this FlowVersionConfigMetaData.
        :type: User
        """
        
        self._created_by_user = created_by_user

    @property
    def created_date(self):
        """
        Gets the created_date of this FlowVersionConfigMetaData.
        The date and time that the version was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :return: The created_date of this FlowVersionConfigMetaData.
        :rtype: datetime
        """
        return self._created_date

    @created_date.setter
    def created_date(self, created_date):
        """
        Sets the created_date of this FlowVersionConfigMetaData.
        The date and time that the version was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :param created_date: The created_date of this FlowVersionConfigMetaData.
        :type: datetime
        """
        
        self._created_date = created_date

    @property
    def self_uri(self):
        """
        Gets the self_uri of this FlowVersionConfigMetaData.
        The URI for this object

        :return: The self_uri of this FlowVersionConfigMetaData.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri):
        """
        Sets the self_uri of this FlowVersionConfigMetaData.
        The URI for this object

        :param self_uri: The self_uri of this FlowVersionConfigMetaData.
        :type: str
        """
        
        self._self_uri = self_uri

    @property
    def version(self):
        """
        Gets the version of this FlowVersionConfigMetaData.
        Version of this flow config.

        :return: The version of this FlowVersionConfigMetaData.
        :rtype: str
        """
        return self._version

    @version.setter
    def version(self, version):
        """
        Sets the version of this FlowVersionConfigMetaData.
        Version of this flow config.

        :param version: The version of this FlowVersionConfigMetaData.
        :type: str
        """
        
        self._version = version

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

