# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re


class Gistener(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        Gistener - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'date_created': 'datetime',
            'date_modified': 'datetime',
            'enabled': 'bool',
            'any_words': 'str',
            'all_words': 'str',
            'exclude_words': 'str',
            'exact_phrase': 'str',
            'group_tags': 'list[GroupTag]',
            'social_account': 'SocialAccount',
            'queue': 'Queue',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'date_created': 'dateCreated',
            'date_modified': 'dateModified',
            'enabled': 'enabled',
            'any_words': 'anyWords',
            'all_words': 'allWords',
            'exclude_words': 'excludeWords',
            'exact_phrase': 'exactPhrase',
            'group_tags': 'groupTags',
            'social_account': 'socialAccount',
            'queue': 'queue',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._name = None
        self._date_created = None
        self._date_modified = None
        self._enabled = False
        self._any_words = None
        self._all_words = None
        self._exclude_words = None
        self._exact_phrase = None
        self._group_tags = None
        self._social_account = None
        self._queue = None
        self._self_uri = None

    @property
    def id(self):
        """
        Gets the id of this Gistener.
        The globally unique identifier for the object.

        :return: The id of this Gistener.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this Gistener.
        The globally unique identifier for the object.

        :param id: The id of this Gistener.
        :type: str
        """
        
        self._id = id

    @property
    def name(self):
        """
        Gets the name of this Gistener.


        :return: The name of this Gistener.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this Gistener.


        :param name: The name of this Gistener.
        :type: str
        """
        
        self._name = name

    @property
    def date_created(self):
        """
        Gets the date_created of this Gistener.
        Creation date for the entity. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :return: The date_created of this Gistener.
        :rtype: datetime
        """
        return self._date_created

    @date_created.setter
    def date_created(self, date_created):
        """
        Sets the date_created of this Gistener.
        Creation date for the entity. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :param date_created: The date_created of this Gistener.
        :type: datetime
        """
        
        self._date_created = date_created

    @property
    def date_modified(self):
        """
        Gets the date_modified of this Gistener.
        Date the entity was last modified. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :return: The date_modified of this Gistener.
        :rtype: datetime
        """
        return self._date_modified

    @date_modified.setter
    def date_modified(self, date_modified):
        """
        Sets the date_modified of this Gistener.
        Date the entity was last modified. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :param date_modified: The date_modified of this Gistener.
        :type: datetime
        """
        
        self._date_modified = date_modified

    @property
    def enabled(self):
        """
        Gets the enabled of this Gistener.
        Indicates if this Gistener may be utilized on another entity

        :return: The enabled of this Gistener.
        :rtype: bool
        """
        return self._enabled

    @enabled.setter
    def enabled(self, enabled):
        """
        Sets the enabled of this Gistener.
        Indicates if this Gistener may be utilized on another entity

        :param enabled: The enabled of this Gistener.
        :type: bool
        """
        
        self._enabled = enabled

    @property
    def any_words(self):
        """
        Gets the any_words of this Gistener.
        A tweet must contain any one of these words

        :return: The any_words of this Gistener.
        :rtype: str
        """
        return self._any_words

    @any_words.setter
    def any_words(self, any_words):
        """
        Sets the any_words of this Gistener.
        A tweet must contain any one of these words

        :param any_words: The any_words of this Gistener.
        :type: str
        """
        
        self._any_words = any_words

    @property
    def all_words(self):
        """
        Gets the all_words of this Gistener.
        A tweet must contain every one of these words in any order

        :return: The all_words of this Gistener.
        :rtype: str
        """
        return self._all_words

    @all_words.setter
    def all_words(self, all_words):
        """
        Sets the all_words of this Gistener.
        A tweet must contain every one of these words in any order

        :param all_words: The all_words of this Gistener.
        :type: str
        """
        
        self._all_words = all_words

    @property
    def exclude_words(self):
        """
        Gets the exclude_words of this Gistener.
        If a tweet contains any one of these words, it is thrown out

        :return: The exclude_words of this Gistener.
        :rtype: str
        """
        return self._exclude_words

    @exclude_words.setter
    def exclude_words(self, exclude_words):
        """
        Sets the exclude_words of this Gistener.
        If a tweet contains any one of these words, it is thrown out

        :param exclude_words: The exclude_words of this Gistener.
        :type: str
        """
        
        self._exclude_words = exclude_words

    @property
    def exact_phrase(self):
        """
        Gets the exact_phrase of this Gistener.
        A tweet must contain this exact quoted phrase

        :return: The exact_phrase of this Gistener.
        :rtype: str
        """
        return self._exact_phrase

    @exact_phrase.setter
    def exact_phrase(self, exact_phrase):
        """
        Sets the exact_phrase of this Gistener.
        A tweet must contain this exact quoted phrase

        :param exact_phrase: The exact_phrase of this Gistener.
        :type: str
        """
        
        self._exact_phrase = exact_phrase

    @property
    def group_tags(self):
        """
        Gets the group_tags of this Gistener.
        The group tags associated with this Gistener

        :return: The group_tags of this Gistener.
        :rtype: list[GroupTag]
        """
        return self._group_tags

    @group_tags.setter
    def group_tags(self, group_tags):
        """
        Sets the group_tags of this Gistener.
        The group tags associated with this Gistener

        :param group_tags: The group_tags of this Gistener.
        :type: list[GroupTag]
        """
        
        self._group_tags = group_tags

    @property
    def social_account(self):
        """
        Gets the social_account of this Gistener.
        The social account associated with this Gistener

        :return: The social_account of this Gistener.
        :rtype: SocialAccount
        """
        return self._social_account

    @social_account.setter
    def social_account(self, social_account):
        """
        Sets the social_account of this Gistener.
        The social account associated with this Gistener

        :param social_account: The social_account of this Gistener.
        :type: SocialAccount
        """
        
        self._social_account = social_account

    @property
    def queue(self):
        """
        Gets the queue of this Gistener.
        The operator queue the gistener will route to.

        :return: The queue of this Gistener.
        :rtype: Queue
        """
        return self._queue

    @queue.setter
    def queue(self, queue):
        """
        Sets the queue of this Gistener.
        The operator queue the gistener will route to.

        :param queue: The queue of this Gistener.
        :type: Queue
        """
        
        self._queue = queue

    @property
    def self_uri(self):
        """
        Gets the self_uri of this Gistener.
        The URI for this object

        :return: The self_uri of this Gistener.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri):
        """
        Sets the self_uri of this Gistener.
        The URI for this object

        :param self_uri: The self_uri of this Gistener.
        :type: str
        """
        
        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

