# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re


class HealthCheckInfo(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        HealthCheckInfo - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'self_uri': 'str',
            'build_time': 'str',
            'build_version': 'str',
            'implementation_version': 'str',
            'status': 'str',
            'ping_ms': 'int',
            'date': 'datetime'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'self_uri': 'selfUri',
            'build_time': 'Build-Time',
            'build_version': 'Build-Version',
            'implementation_version': 'Implementation-Version',
            'status': 'Status',
            'ping_ms': 'Ping-Ms',
            'date': 'Date'
        }

        self._id = None
        self._name = None
        self._self_uri = None
        self._build_time = None
        self._build_version = None
        self._implementation_version = None
        self._status = None
        self._ping_ms = None
        self._date = None

    @property
    def id(self):
        """
        Gets the id of this HealthCheckInfo.
        The globally unique identifier for the object.

        :return: The id of this HealthCheckInfo.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this HealthCheckInfo.
        The globally unique identifier for the object.

        :param id: The id of this HealthCheckInfo.
        :type: str
        """
        
        self._id = id

    @property
    def name(self):
        """
        Gets the name of this HealthCheckInfo.


        :return: The name of this HealthCheckInfo.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this HealthCheckInfo.


        :param name: The name of this HealthCheckInfo.
        :type: str
        """
        
        self._name = name

    @property
    def self_uri(self):
        """
        Gets the self_uri of this HealthCheckInfo.
        The URI for this object

        :return: The self_uri of this HealthCheckInfo.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri):
        """
        Sets the self_uri of this HealthCheckInfo.
        The URI for this object

        :param self_uri: The self_uri of this HealthCheckInfo.
        :type: str
        """
        
        self._self_uri = self_uri

    @property
    def build_time(self):
        """
        Gets the build_time of this HealthCheckInfo.


        :return: The build_time of this HealthCheckInfo.
        :rtype: str
        """
        return self._build_time

    @build_time.setter
    def build_time(self, build_time):
        """
        Sets the build_time of this HealthCheckInfo.


        :param build_time: The build_time of this HealthCheckInfo.
        :type: str
        """
        
        self._build_time = build_time

    @property
    def build_version(self):
        """
        Gets the build_version of this HealthCheckInfo.


        :return: The build_version of this HealthCheckInfo.
        :rtype: str
        """
        return self._build_version

    @build_version.setter
    def build_version(self, build_version):
        """
        Sets the build_version of this HealthCheckInfo.


        :param build_version: The build_version of this HealthCheckInfo.
        :type: str
        """
        
        self._build_version = build_version

    @property
    def implementation_version(self):
        """
        Gets the implementation_version of this HealthCheckInfo.


        :return: The implementation_version of this HealthCheckInfo.
        :rtype: str
        """
        return self._implementation_version

    @implementation_version.setter
    def implementation_version(self, implementation_version):
        """
        Sets the implementation_version of this HealthCheckInfo.


        :param implementation_version: The implementation_version of this HealthCheckInfo.
        :type: str
        """
        
        self._implementation_version = implementation_version

    @property
    def status(self):
        """
        Gets the status of this HealthCheckInfo.


        :return: The status of this HealthCheckInfo.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """
        Sets the status of this HealthCheckInfo.


        :param status: The status of this HealthCheckInfo.
        :type: str
        """
        allowed_values = ["OK", "CREATED", "ACCEPTED", "NO_CONTENT", "RESET_CONTENT", "PARTIAL_CONTENT", "MOVED_PERMANENTLY", "FOUND", "SEE_OTHER", "NOT_MODIFIED", "USE_PROXY", "TEMPORARY_REDIRECT", "BAD_REQUEST", "UNAUTHORIZED", "PAYMENT_REQUIRED", "FORBIDDEN", "NOT_FOUND", "METHOD_NOT_ALLOWED", "NOT_ACCEPTABLE", "PROXY_AUTHENTICATION_REQUIRED", "REQUEST_TIMEOUT", "CONFLICT", "GONE", "LENGTH_REQUIRED", "PRECONDITION_FAILED", "REQUEST_ENTITY_TOO_LARGE", "REQUEST_URI_TOO_LONG", "UNSUPPORTED_MEDIA_TYPE", "REQUESTED_RANGE_NOT_SATISFIABLE", "EXPECTATION_FAILED", "INTERNAL_SERVER_ERROR", "NOT_IMPLEMENTED", "BAD_GATEWAY", "SERVICE_UNAVAILABLE", "GATEWAY_TIMEOUT", "HTTP_VERSION_NOT_SUPPORTED"]
        if status not in allowed_values:
            raise ValueError(
                "Invalid value for `status`, must be one of {0}"
                .format(allowed_values)
            )

        self._status = status

    @property
    def ping_ms(self):
        """
        Gets the ping_ms of this HealthCheckInfo.


        :return: The ping_ms of this HealthCheckInfo.
        :rtype: int
        """
        return self._ping_ms

    @ping_ms.setter
    def ping_ms(self, ping_ms):
        """
        Sets the ping_ms of this HealthCheckInfo.


        :param ping_ms: The ping_ms of this HealthCheckInfo.
        :type: int
        """
        
        self._ping_ms = ping_ms

    @property
    def date(self):
        """
        Gets the date of this HealthCheckInfo.
        Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :return: The date of this HealthCheckInfo.
        :rtype: datetime
        """
        return self._date

    @date.setter
    def date(self, date):
        """
        Sets the date of this HealthCheckInfo.
        Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :param date: The date of this HealthCheckInfo.
        :type: datetime
        """
        
        self._date = date

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

