# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re


class Integration(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        Integration - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'integration_type': 'IntegrationType',
            'state': 'str',
            'config': 'IntegrationConfiguration',
            'last_status': 'IntegrationStatusInfo',
            'version': 'int',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'integration_type': 'integrationType',
            'state': 'state',
            'config': 'config',
            'last_status': 'lastStatus',
            'version': 'version',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._name = None
        self._integration_type = None
        self._state = None
        self._config = None
        self._last_status = None
        self._version = None
        self._self_uri = None

    @property
    def id(self):
        """
        Gets the id of this Integration.
        The globally unique identifier for the object.

        :return: The id of this Integration.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this Integration.
        The globally unique identifier for the object.

        :param id: The id of this Integration.
        :type: str
        """
        
        self._id = id

    @property
    def name(self):
        """
        Gets the name of this Integration.
        The name of the integration, used to distinguish this integration from others of the same type.

        :return: The name of this Integration.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this Integration.
        The name of the integration, used to distinguish this integration from others of the same type.

        :param name: The name of this Integration.
        :type: str
        """
        
        self._name = name

    @property
    def integration_type(self):
        """
        Gets the integration_type of this Integration.
        Type of the integration

        :return: The integration_type of this Integration.
        :rtype: IntegrationType
        """
        return self._integration_type

    @integration_type.setter
    def integration_type(self, integration_type):
        """
        Sets the integration_type of this Integration.
        Type of the integration

        :param integration_type: The integration_type of this Integration.
        :type: IntegrationType
        """
        
        self._integration_type = integration_type

    @property
    def state(self):
        """
        Gets the state of this Integration.
        Configured state of the integration.

        :return: The state of this Integration.
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state):
        """
        Sets the state of this Integration.
        Configured state of the integration.

        :param state: The state of this Integration.
        :type: str
        """
        allowed_values = ["ENABLED", "DISABLED", "DELETED"]
        if state not in allowed_values:
            raise ValueError(
                "Invalid value for `state`, must be one of {0}"
                .format(allowed_values)
            )

        self._state = state

    @property
    def config(self):
        """
        Gets the config of this Integration.
        Configuration for the integration.

        :return: The config of this Integration.
        :rtype: IntegrationConfiguration
        """
        return self._config

    @config.setter
    def config(self, config):
        """
        Sets the config of this Integration.
        Configuration for the integration.

        :param config: The config of this Integration.
        :type: IntegrationConfiguration
        """
        
        self._config = config

    @property
    def last_status(self):
        """
        Gets the last_status of this Integration.
        Last reported status of the integration.

        :return: The last_status of this Integration.
        :rtype: IntegrationStatusInfo
        """
        return self._last_status

    @last_status.setter
    def last_status(self, last_status):
        """
        Sets the last_status of this Integration.
        Last reported status of the integration.

        :param last_status: The last_status of this Integration.
        :type: IntegrationStatusInfo
        """
        
        self._last_status = last_status

    @property
    def version(self):
        """
        Gets the version of this Integration.
        Version number required for updates.

        :return: The version of this Integration.
        :rtype: int
        """
        return self._version

    @version.setter
    def version(self, version):
        """
        Sets the version of this Integration.
        Version number required for updates.

        :param version: The version of this Integration.
        :type: int
        """
        
        self._version = version

    @property
    def self_uri(self):
        """
        Gets the self_uri of this Integration.
        The URI for this object

        :return: The self_uri of this Integration.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri):
        """
        Sets the self_uri of this Integration.
        The URI for this object

        :param self_uri: The self_uri of this Integration.
        :type: str
        """
        
        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

