# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re


class IntegrationStatusInfo(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        IntegrationStatusInfo - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'internal': 'str',
            'effective': 'str',
            'detail': 'str',
            'last_updated': 'datetime'
        }

        self.attribute_map = {
            'internal': 'internal',
            'effective': 'effective',
            'detail': 'detail',
            'last_updated': 'lastUpdated'
        }

        self._internal = None
        self._effective = None
        self._detail = None
        self._last_updated = None

    @property
    def internal(self):
        """
        Gets the internal of this IntegrationStatusInfo.
        Machine-readable status as reported by the integration.

        :return: The internal of this IntegrationStatusInfo.
        :rtype: str
        """
        return self._internal

    @internal.setter
    def internal(self, internal):
        """
        Sets the internal of this IntegrationStatusInfo.
        Machine-readable status as reported by the integration.

        :param internal: The internal of this IntegrationStatusInfo.
        :type: str
        """
        allowed_values = ["ACTIVE", "ACTIVATING", "INACTIVE", "DEACTIVATING", "ERROR"]
        if internal not in allowed_values:
            raise ValueError(
                "Invalid value for `internal`, must be one of {0}"
                .format(allowed_values)
            )

        self._internal = internal

    @property
    def effective(self):
        """
        Gets the effective of this IntegrationStatusInfo.
        Localized, human-readable, effective status of the integration.

        :return: The effective of this IntegrationStatusInfo.
        :rtype: str
        """
        return self._effective

    @effective.setter
    def effective(self, effective):
        """
        Sets the effective of this IntegrationStatusInfo.
        Localized, human-readable, effective status of the integration.

        :param effective: The effective of this IntegrationStatusInfo.
        :type: str
        """
        
        self._effective = effective

    @property
    def detail(self):
        """
        Gets the detail of this IntegrationStatusInfo.
        Localized status details for the integration.

        :return: The detail of this IntegrationStatusInfo.
        :rtype: str
        """
        return self._detail

    @detail.setter
    def detail(self, detail):
        """
        Sets the detail of this IntegrationStatusInfo.
        Localized status details for the integration.

        :param detail: The detail of this IntegrationStatusInfo.
        :type: str
        """
        
        self._detail = detail

    @property
    def last_updated(self):
        """
        Gets the last_updated of this IntegrationStatusInfo.
        Date and time (in UTC) when the integration status (i.e. the internal field) was last updated. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :return: The last_updated of this IntegrationStatusInfo.
        :rtype: datetime
        """
        return self._last_updated

    @last_updated.setter
    def last_updated(self, last_updated):
        """
        Sets the last_updated of this IntegrationStatusInfo.
        Date and time (in UTC) when the integration status (i.e. the internal field) was last updated. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :param last_updated: The last_updated of this IntegrationStatusInfo.
        :type: datetime
        """
        
        self._last_updated = last_updated

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

