# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re


class IntegrationType(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        IntegrationType - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'description': 'str',
            'provider': 'str',
            'images': 'list[UserImage]',
            'config_properties_schema_uri': 'str',
            'config_advanced_schema_uri': 'str',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'description': 'description',
            'provider': 'provider',
            'images': 'images',
            'config_properties_schema_uri': 'configPropertiesSchemaUri',
            'config_advanced_schema_uri': 'configAdvancedSchemaUri',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._name = None
        self._description = None
        self._provider = None
        self._images = None
        self._config_properties_schema_uri = None
        self._config_advanced_schema_uri = None
        self._self_uri = None

    @property
    def id(self):
        """
        Gets the id of this IntegrationType.
        The ID of the integration type.

        :return: The id of this IntegrationType.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this IntegrationType.
        The ID of the integration type.

        :param id: The id of this IntegrationType.
        :type: str
        """
        
        self._id = id

    @property
    def name(self):
        """
        Gets the name of this IntegrationType.


        :return: The name of this IntegrationType.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this IntegrationType.


        :param name: The name of this IntegrationType.
        :type: str
        """
        
        self._name = name

    @property
    def description(self):
        """
        Gets the description of this IntegrationType.
        Localized description of the integration type.

        :return: The description of this IntegrationType.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this IntegrationType.
        Localized description of the integration type.

        :param description: The description of this IntegrationType.
        :type: str
        """
        
        self._description = description

    @property
    def provider(self):
        """
        Gets the provider of this IntegrationType.
        PureCloud provider of the integration type.

        :return: The provider of this IntegrationType.
        :rtype: str
        """
        return self._provider

    @provider.setter
    def provider(self, provider):
        """
        Sets the provider of this IntegrationType.
        PureCloud provider of the integration type.

        :param provider: The provider of this IntegrationType.
        :type: str
        """
        
        self._provider = provider

    @property
    def images(self):
        """
        Gets the images of this IntegrationType.
        Collection of logos.

        :return: The images of this IntegrationType.
        :rtype: list[UserImage]
        """
        return self._images

    @images.setter
    def images(self, images):
        """
        Sets the images of this IntegrationType.
        Collection of logos.

        :param images: The images of this IntegrationType.
        :type: list[UserImage]
        """
        
        self._images = images

    @property
    def config_properties_schema_uri(self):
        """
        Gets the config_properties_schema_uri of this IntegrationType.
        URI of the schema describing the key-value properties needed to configure an integration of this type.

        :return: The config_properties_schema_uri of this IntegrationType.
        :rtype: str
        """
        return self._config_properties_schema_uri

    @config_properties_schema_uri.setter
    def config_properties_schema_uri(self, config_properties_schema_uri):
        """
        Sets the config_properties_schema_uri of this IntegrationType.
        URI of the schema describing the key-value properties needed to configure an integration of this type.

        :param config_properties_schema_uri: The config_properties_schema_uri of this IntegrationType.
        :type: str
        """
        
        self._config_properties_schema_uri = config_properties_schema_uri

    @property
    def config_advanced_schema_uri(self):
        """
        Gets the config_advanced_schema_uri of this IntegrationType.
        URI of the schema describing the advanced JSON document needed to configure an integration of this type.

        :return: The config_advanced_schema_uri of this IntegrationType.
        :rtype: str
        """
        return self._config_advanced_schema_uri

    @config_advanced_schema_uri.setter
    def config_advanced_schema_uri(self, config_advanced_schema_uri):
        """
        Sets the config_advanced_schema_uri of this IntegrationType.
        URI of the schema describing the advanced JSON document needed to configure an integration of this type.

        :param config_advanced_schema_uri: The config_advanced_schema_uri of this IntegrationType.
        :type: str
        """
        
        self._config_advanced_schema_uri = config_advanced_schema_uri

    @property
    def self_uri(self):
        """
        Gets the self_uri of this IntegrationType.
        The URI for this object

        :return: The self_uri of this IntegrationType.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri):
        """
        Sets the self_uri of this IntegrationType.
        The URI for this object

        :param self_uri: The self_uri of this IntegrationType.
        :type: str
        """
        
        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

