# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re


class Invoice(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        Invoice - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'invoice_number': 'str',
            'invoice_date': 'datetime',
            'due_date': 'datetime',
            'amount': 'str',
            'balance': 'str',
            'status': 'str',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'invoice_number': 'invoiceNumber',
            'invoice_date': 'invoiceDate',
            'due_date': 'dueDate',
            'amount': 'amount',
            'balance': 'balance',
            'status': 'status',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._name = None
        self._invoice_number = None
        self._invoice_date = None
        self._due_date = None
        self._amount = None
        self._balance = None
        self._status = None
        self._self_uri = None

    @property
    def id(self):
        """
        Gets the id of this Invoice.
        The globally unique identifier for the object.

        :return: The id of this Invoice.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this Invoice.
        The globally unique identifier for the object.

        :param id: The id of this Invoice.
        :type: str
        """
        
        self._id = id

    @property
    def name(self):
        """
        Gets the name of this Invoice.


        :return: The name of this Invoice.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this Invoice.


        :param name: The name of this Invoice.
        :type: str
        """
        
        self._name = name

    @property
    def invoice_number(self):
        """
        Gets the invoice_number of this Invoice.


        :return: The invoice_number of this Invoice.
        :rtype: str
        """
        return self._invoice_number

    @invoice_number.setter
    def invoice_number(self, invoice_number):
        """
        Sets the invoice_number of this Invoice.


        :param invoice_number: The invoice_number of this Invoice.
        :type: str
        """
        
        self._invoice_number = invoice_number

    @property
    def invoice_date(self):
        """
        Gets the invoice_date of this Invoice.
        Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :return: The invoice_date of this Invoice.
        :rtype: datetime
        """
        return self._invoice_date

    @invoice_date.setter
    def invoice_date(self, invoice_date):
        """
        Sets the invoice_date of this Invoice.
        Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :param invoice_date: The invoice_date of this Invoice.
        :type: datetime
        """
        
        self._invoice_date = invoice_date

    @property
    def due_date(self):
        """
        Gets the due_date of this Invoice.
        Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :return: The due_date of this Invoice.
        :rtype: datetime
        """
        return self._due_date

    @due_date.setter
    def due_date(self, due_date):
        """
        Sets the due_date of this Invoice.
        Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :param due_date: The due_date of this Invoice.
        :type: datetime
        """
        
        self._due_date = due_date

    @property
    def amount(self):
        """
        Gets the amount of this Invoice.


        :return: The amount of this Invoice.
        :rtype: str
        """
        return self._amount

    @amount.setter
    def amount(self, amount):
        """
        Sets the amount of this Invoice.


        :param amount: The amount of this Invoice.
        :type: str
        """
        
        self._amount = amount

    @property
    def balance(self):
        """
        Gets the balance of this Invoice.


        :return: The balance of this Invoice.
        :rtype: str
        """
        return self._balance

    @balance.setter
    def balance(self, balance):
        """
        Sets the balance of this Invoice.


        :param balance: The balance of this Invoice.
        :type: str
        """
        
        self._balance = balance

    @property
    def status(self):
        """
        Gets the status of this Invoice.


        :return: The status of this Invoice.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """
        Sets the status of this Invoice.


        :param status: The status of this Invoice.
        :type: str
        """
        
        self._status = status

    @property
    def self_uri(self):
        """
        Gets the self_uri of this Invoice.
        The URI for this object

        :return: The self_uri of this Invoice.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri):
        """
        Sets the self_uri of this Invoice.
        The URI for this object

        :param self_uri: The self_uri of this Invoice.
        :type: str
        """
        
        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

