# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re


class LocationAddress(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        LocationAddress - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'city': 'str',
            'country': 'str',
            'country_name': 'str',
            'state': 'str',
            'street1': 'str',
            'street2': 'str',
            'zipcode': 'str'
        }

        self.attribute_map = {
            'city': 'city',
            'country': 'country',
            'country_name': 'countryName',
            'state': 'state',
            'street1': 'street1',
            'street2': 'street2',
            'zipcode': 'zipcode'
        }

        self._city = None
        self._country = None
        self._country_name = None
        self._state = None
        self._street1 = None
        self._street2 = None
        self._zipcode = None

    @property
    def city(self):
        """
        Gets the city of this LocationAddress.


        :return: The city of this LocationAddress.
        :rtype: str
        """
        return self._city

    @city.setter
    def city(self, city):
        """
        Sets the city of this LocationAddress.


        :param city: The city of this LocationAddress.
        :type: str
        """
        
        self._city = city

    @property
    def country(self):
        """
        Gets the country of this LocationAddress.


        :return: The country of this LocationAddress.
        :rtype: str
        """
        return self._country

    @country.setter
    def country(self, country):
        """
        Sets the country of this LocationAddress.


        :param country: The country of this LocationAddress.
        :type: str
        """
        
        self._country = country

    @property
    def country_name(self):
        """
        Gets the country_name of this LocationAddress.


        :return: The country_name of this LocationAddress.
        :rtype: str
        """
        return self._country_name

    @country_name.setter
    def country_name(self, country_name):
        """
        Sets the country_name of this LocationAddress.


        :param country_name: The country_name of this LocationAddress.
        :type: str
        """
        
        self._country_name = country_name

    @property
    def state(self):
        """
        Gets the state of this LocationAddress.


        :return: The state of this LocationAddress.
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state):
        """
        Sets the state of this LocationAddress.


        :param state: The state of this LocationAddress.
        :type: str
        """
        
        self._state = state

    @property
    def street1(self):
        """
        Gets the street1 of this LocationAddress.


        :return: The street1 of this LocationAddress.
        :rtype: str
        """
        return self._street1

    @street1.setter
    def street1(self, street1):
        """
        Sets the street1 of this LocationAddress.


        :param street1: The street1 of this LocationAddress.
        :type: str
        """
        
        self._street1 = street1

    @property
    def street2(self):
        """
        Gets the street2 of this LocationAddress.


        :return: The street2 of this LocationAddress.
        :rtype: str
        """
        return self._street2

    @street2.setter
    def street2(self, street2):
        """
        Sets the street2 of this LocationAddress.


        :param street2: The street2 of this LocationAddress.
        :type: str
        """
        
        self._street2 = street2

    @property
    def zipcode(self):
        """
        Gets the zipcode of this LocationAddress.


        :return: The zipcode of this LocationAddress.
        :rtype: str
        """
        return self._zipcode

    @zipcode.setter
    def zipcode(self, zipcode):
        """
        Sets the zipcode of this LocationAddress.


        :param zipcode: The zipcode of this LocationAddress.
        :type: str
        """
        
        self._zipcode = zipcode

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

