# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re


class NumberOrder(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        NumberOrder - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'did': 'str',
            'effective_start_date': 'datetime',
            'effective_end_date': 'datetime',
            'last_updated': 'datetime',
            'start_auth_user_id': 'str',
            'end_auth_user_id': 'str',
            'status': 'str',
            'phone_number_type': 'str',
            'porting': 'bool',
            'billing_address': 'PortBillingAddress',
            'responsible_contact': 'PortContact',
            'company_name': 'str',
            'country_code': 'str',
            'envelope_id': 'str',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'did': 'did',
            'effective_start_date': 'effectiveStartDate',
            'effective_end_date': 'effectiveEndDate',
            'last_updated': 'lastUpdated',
            'start_auth_user_id': 'startAuthUserId',
            'end_auth_user_id': 'endAuthUserId',
            'status': 'status',
            'phone_number_type': 'phoneNumberType',
            'porting': 'porting',
            'billing_address': 'billingAddress',
            'responsible_contact': 'responsibleContact',
            'company_name': 'companyName',
            'country_code': 'countryCode',
            'envelope_id': 'envelopeId',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._name = None
        self._did = None
        self._effective_start_date = None
        self._effective_end_date = None
        self._last_updated = None
        self._start_auth_user_id = None
        self._end_auth_user_id = None
        self._status = None
        self._phone_number_type = None
        self._porting = False
        self._billing_address = None
        self._responsible_contact = None
        self._company_name = None
        self._country_code = None
        self._envelope_id = None
        self._self_uri = None

    @property
    def id(self):
        """
        Gets the id of this NumberOrder.
        The globally unique identifier for the object.

        :return: The id of this NumberOrder.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this NumberOrder.
        The globally unique identifier for the object.

        :param id: The id of this NumberOrder.
        :type: str
        """
        
        self._id = id

    @property
    def name(self):
        """
        Gets the name of this NumberOrder.


        :return: The name of this NumberOrder.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this NumberOrder.


        :param name: The name of this NumberOrder.
        :type: str
        """
        
        self._name = name

    @property
    def did(self):
        """
        Gets the did of this NumberOrder.
        DID purchased

        :return: The did of this NumberOrder.
        :rtype: str
        """
        return self._did

    @did.setter
    def did(self, did):
        """
        Sets the did of this NumberOrder.
        DID purchased

        :param did: The did of this NumberOrder.
        :type: str
        """
        
        self._did = did

    @property
    def effective_start_date(self):
        """
        Gets the effective_start_date of this NumberOrder.
        Effective date of service for this order. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :return: The effective_start_date of this NumberOrder.
        :rtype: datetime
        """
        return self._effective_start_date

    @effective_start_date.setter
    def effective_start_date(self, effective_start_date):
        """
        Sets the effective_start_date of this NumberOrder.
        Effective date of service for this order. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :param effective_start_date: The effective_start_date of this NumberOrder.
        :type: datetime
        """
        
        self._effective_start_date = effective_start_date

    @property
    def effective_end_date(self):
        """
        Gets the effective_end_date of this NumberOrder.
        Effective disconnection date for this order. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :return: The effective_end_date of this NumberOrder.
        :rtype: datetime
        """
        return self._effective_end_date

    @effective_end_date.setter
    def effective_end_date(self, effective_end_date):
        """
        Sets the effective_end_date of this NumberOrder.
        Effective disconnection date for this order. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :param effective_end_date: The effective_end_date of this NumberOrder.
        :type: datetime
        """
        
        self._effective_end_date = effective_end_date

    @property
    def last_updated(self):
        """
        Gets the last_updated of this NumberOrder.
        Date of last update. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :return: The last_updated of this NumberOrder.
        :rtype: datetime
        """
        return self._last_updated

    @last_updated.setter
    def last_updated(self, last_updated):
        """
        Sets the last_updated of this NumberOrder.
        Date of last update. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :param last_updated: The last_updated of this NumberOrder.
        :type: datetime
        """
        
        self._last_updated = last_updated

    @property
    def start_auth_user_id(self):
        """
        Gets the start_auth_user_id of this NumberOrder.
        UserId authorizing purchase

        :return: The start_auth_user_id of this NumberOrder.
        :rtype: str
        """
        return self._start_auth_user_id

    @start_auth_user_id.setter
    def start_auth_user_id(self, start_auth_user_id):
        """
        Sets the start_auth_user_id of this NumberOrder.
        UserId authorizing purchase

        :param start_auth_user_id: The start_auth_user_id of this NumberOrder.
        :type: str
        """
        
        self._start_auth_user_id = start_auth_user_id

    @property
    def end_auth_user_id(self):
        """
        Gets the end_auth_user_id of this NumberOrder.
        UserId authorizing disconnection

        :return: The end_auth_user_id of this NumberOrder.
        :rtype: str
        """
        return self._end_auth_user_id

    @end_auth_user_id.setter
    def end_auth_user_id(self, end_auth_user_id):
        """
        Sets the end_auth_user_id of this NumberOrder.
        UserId authorizing disconnection

        :param end_auth_user_id: The end_auth_user_id of this NumberOrder.
        :type: str
        """
        
        self._end_auth_user_id = end_auth_user_id

    @property
    def status(self):
        """
        Gets the status of this NumberOrder.
        Current status of this DID order

        :return: The status of this NumberOrder.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """
        Sets the status of this NumberOrder.
        Current status of this DID order

        :param status: The status of this NumberOrder.
        :type: str
        """
        allowed_values = ["COMPLETE", "CONNECTING", "FAILED", "BACKORDERED", "PENDING", "ACTIVATING", "ACTIVATION_ERROR", "ERROR", "DISCONNECTED", "DISCONNECT_PENDING", "DEACTIVATING", "DEACTIVATION_ERROR", "DISCONNECT_FAILED", "SUBMITTED", "REJECTED", "SUPP", "PORT_PENDING", "FOC"]
        if status not in allowed_values:
            raise ValueError(
                "Invalid value for `status`, must be one of {0}"
                .format(allowed_values)
            )

        self._status = status

    @property
    def phone_number_type(self):
        """
        Gets the phone_number_type of this NumberOrder.
        Class of DID being purchased (eg. us-domestic, toll-free, etc)

        :return: The phone_number_type of this NumberOrder.
        :rtype: str
        """
        return self._phone_number_type

    @phone_number_type.setter
    def phone_number_type(self, phone_number_type):
        """
        Sets the phone_number_type of this NumberOrder.
        Class of DID being purchased (eg. us-domestic, toll-free, etc)

        :param phone_number_type: The phone_number_type of this NumberOrder.
        :type: str
        """
        allowed_values = ["TOLL_FREE", "CN_DOMESTIC", "US_DOMESTIC", "US_TOLLFREE", "XA_TOLLFREE", "XB_TOLLFREE", "XC_TOLLFREE", "AG_DID", "AI_DID", "BB_DID", "BM_DID", "BS_DID", "CA_DID", "DM_DID", "DO_DID", "GD_DID", "JM_DID", "KN_DID", "KY_DID", "KZ_DID", "LC_DID", "MP_DID", "MS_DID", "RU_DID", "TC_DID", "TT_DID", "US_DID", "VC_DID", "VG_DID", "AF_DID", "AR_DID", "AT_DID", "AU_DID", "BE_DID", "BR_DID", "CH_DID", "CL_DID", "CN_DID", "CO_DID", "CU_DID", "DE_DID", "DK_DID", "EG_DID", "ES_DID", "FR_DID", "GB_DID", "GR_DID", "HU_DID", "ID_DID", "IN_DID", "IR_DID", "IT_DID", "JP_DID", "KR_DID", "LK_DID", "MM_DID", "MX_DID", "MY_DID", "NL_DID", "NO_DID", "NZ_DID", "PE_DID", "PH_DID", "PK_DID", "PL_DID", "RO_DID", "SE_DID", "SG_DID", "TH_DID", "TR_DID", "VE_DID", "VN_DID", "ZA_DID", "AD_DID", "AE_DID", "AL_DID", "AM_DID", "AO_DID", "AQ_DID", "AW_DID", "AZ_DID", "BA_DID", "BD_DID", "BF_DID", "BG_DID", "BH_DID", "BI_DID", "BJ_DID", "BL_DID", "BN_DID", "BO_DID", "BQ_DID", "BT_DID", "BW_DID", "BY_DID", "BZ_DID", "CD_DID", "CF_DID", "CG_DID", "CI_DID", "CK_DID", "CM_DID", "CR_DID", "CV_DID", "CY_DID", "CZ_DID", "DJ_DID", "DZ_DID", "EC_DID", "EE_DID", "EH_DID", "ER_DID", "ET_DID", "FI_DID", "FJ_DID", "FK_DID", "FM_DID", "FO_DID", "GA_DID", "GE_DID", "GF_DID", "GH_DID", "GI_DID", "GL_DID", "GM_DID", "GN_DID", "GP_DID", "GQ_DID", "GT_DID", "GW_DID", "GY_DID", "HK_DID", "HN_DID", "HR_DID", "HT_DID", "IE_DID", "IL_DID", "IO_DID", "IQ_DID", "IS_DID", "JO_DID", "KE_DID", "KG_DID", "KH_DID", "KI_DID", "KM_DID", "KP_DID", "KW_DID", "LA_DID", "LB_DID", "LI_DID", "LR_DID", "LS_DID", "LT_DID", "LU_DID", "LV_DID", "LY_DID", "MA_DID", "MC_DID", "MD_DID", "ME_DID", "MF_DID", "MG_DID", "MH_DID", "MK_DID", "ML_DID", "MN_DID", "MO_DID", "MQ_DID", "MR_DID", "MT_DID", "MU_DID", "MV_DID", "MW_DID", "MZ_DID", "NA_DID", "NC_DID", "NE_DID", "NF_DID", "NG_DID", "NI_DID", "NP_DID", "NR_DID", "NU_DID", "OM_DID", "PA_DID", "PF_DID", "PG_DID", "PM_DID", "PS_DID", "PT_DID", "PW_DID", "PY_DID", "QA_DID", "RE_DID", "RS_DID", "RW_DID", "SA_DID", "SB_DID", "SC_DID", "SD_DID", "SH_247_DID", "SH_290_DID", "SI_DID", "SK_DID", "SL_DID", "SM_DID", "SN_DID", "SO_DID", "SR_DID", "SS_DID", "ST_DID", "SV_DID", "SY_DID", "SZ_DID", "TD_DID", "TG_DID", "TJ_DID", "TK_DID", "TL_DID", "TM_DID", "TN_DID", "TO_DID", "TV_DID", "TW_DID", "TZ_DID", "UA_DID", "UG_DID", "UY_DID", "UZ_DID", "VU_DID", "WF_DID", "WS_DID", "XG_DID", "XN_DID", "XV_882_DID", "XV_883_DID", "YE_DID", "YT_DID", "ZM_DID", "ZW_DID", "SX_DID"]
        if phone_number_type not in allowed_values:
            raise ValueError(
                "Invalid value for `phone_number_type`, must be one of {0}"
                .format(allowed_values)
            )

        self._phone_number_type = phone_number_type

    @property
    def porting(self):
        """
        Gets the porting of this NumberOrder.
        Whether or not the number was ported

        :return: The porting of this NumberOrder.
        :rtype: bool
        """
        return self._porting

    @porting.setter
    def porting(self, porting):
        """
        Sets the porting of this NumberOrder.
        Whether or not the number was ported

        :param porting: The porting of this NumberOrder.
        :type: bool
        """
        
        self._porting = porting

    @property
    def billing_address(self):
        """
        Gets the billing_address of this NumberOrder.
        Billing address used for a number port

        :return: The billing_address of this NumberOrder.
        :rtype: PortBillingAddress
        """
        return self._billing_address

    @billing_address.setter
    def billing_address(self, billing_address):
        """
        Sets the billing_address of this NumberOrder.
        Billing address used for a number port

        :param billing_address: The billing_address of this NumberOrder.
        :type: PortBillingAddress
        """
        
        self._billing_address = billing_address

    @property
    def responsible_contact(self):
        """
        Gets the responsible_contact of this NumberOrder.
        Company contact for a number port

        :return: The responsible_contact of this NumberOrder.
        :rtype: PortContact
        """
        return self._responsible_contact

    @responsible_contact.setter
    def responsible_contact(self, responsible_contact):
        """
        Sets the responsible_contact of this NumberOrder.
        Company contact for a number port

        :param responsible_contact: The responsible_contact of this NumberOrder.
        :type: PortContact
        """
        
        self._responsible_contact = responsible_contact

    @property
    def company_name(self):
        """
        Gets the company_name of this NumberOrder.
        Company name for a number port

        :return: The company_name of this NumberOrder.
        :rtype: str
        """
        return self._company_name

    @company_name.setter
    def company_name(self, company_name):
        """
        Sets the company_name of this NumberOrder.
        Company name for a number port

        :param company_name: The company_name of this NumberOrder.
        :type: str
        """
        
        self._company_name = company_name

    @property
    def country_code(self):
        """
        Gets the country_code of this NumberOrder.
        Country dial in codes (telephone dialing prefixes)

        :return: The country_code of this NumberOrder.
        :rtype: str
        """
        return self._country_code

    @country_code.setter
    def country_code(self, country_code):
        """
        Sets the country_code of this NumberOrder.
        Country dial in codes (telephone dialing prefixes)

        :param country_code: The country_code of this NumberOrder.
        :type: str
        """
        
        self._country_code = country_code

    @property
    def envelope_id(self):
        """
        Gets the envelope_id of this NumberOrder.
        Id of the terms and conditions envelope for the order.

        :return: The envelope_id of this NumberOrder.
        :rtype: str
        """
        return self._envelope_id

    @envelope_id.setter
    def envelope_id(self, envelope_id):
        """
        Sets the envelope_id of this NumberOrder.
        Id of the terms and conditions envelope for the order.

        :param envelope_id: The envelope_id of this NumberOrder.
        :type: str
        """
        
        self._envelope_id = envelope_id

    @property
    def self_uri(self):
        """
        Gets the self_uri of this NumberOrder.
        The URI for this object

        :return: The self_uri of this NumberOrder.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri):
        """
        Sets the self_uri of this NumberOrder.
        The URI for this object

        :param self_uri: The self_uri of this NumberOrder.
        :type: str
        """
        
        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

