# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re


class NumberOrderRequest(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        NumberOrderRequest - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'order_tns': 'list[str]',
            'reservation_ids': 'list[str]',
            'order_id': 'str',
            'effective_date': 'datetime',
            'phone_number_type': 'str'
        }

        self.attribute_map = {
            'order_tns': 'orderTns',
            'reservation_ids': 'reservationIds',
            'order_id': 'orderId',
            'effective_date': 'effectiveDate',
            'phone_number_type': 'phoneNumberType'
        }

        self._order_tns = None
        self._reservation_ids = None
        self._order_id = None
        self._effective_date = None
        self._phone_number_type = None

    @property
    def order_tns(self):
        """
        Gets the order_tns of this NumberOrderRequest.


        :return: The order_tns of this NumberOrderRequest.
        :rtype: list[str]
        """
        return self._order_tns

    @order_tns.setter
    def order_tns(self, order_tns):
        """
        Sets the order_tns of this NumberOrderRequest.


        :param order_tns: The order_tns of this NumberOrderRequest.
        :type: list[str]
        """
        
        self._order_tns = order_tns

    @property
    def reservation_ids(self):
        """
        Gets the reservation_ids of this NumberOrderRequest.


        :return: The reservation_ids of this NumberOrderRequest.
        :rtype: list[str]
        """
        return self._reservation_ids

    @reservation_ids.setter
    def reservation_ids(self, reservation_ids):
        """
        Sets the reservation_ids of this NumberOrderRequest.


        :param reservation_ids: The reservation_ids of this NumberOrderRequest.
        :type: list[str]
        """
        
        self._reservation_ids = reservation_ids

    @property
    def order_id(self):
        """
        Gets the order_id of this NumberOrderRequest.


        :return: The order_id of this NumberOrderRequest.
        :rtype: str
        """
        return self._order_id

    @order_id.setter
    def order_id(self, order_id):
        """
        Sets the order_id of this NumberOrderRequest.


        :param order_id: The order_id of this NumberOrderRequest.
        :type: str
        """
        
        self._order_id = order_id

    @property
    def effective_date(self):
        """
        Gets the effective_date of this NumberOrderRequest.
        Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :return: The effective_date of this NumberOrderRequest.
        :rtype: datetime
        """
        return self._effective_date

    @effective_date.setter
    def effective_date(self, effective_date):
        """
        Sets the effective_date of this NumberOrderRequest.
        Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :param effective_date: The effective_date of this NumberOrderRequest.
        :type: datetime
        """
        
        self._effective_date = effective_date

    @property
    def phone_number_type(self):
        """
        Gets the phone_number_type of this NumberOrderRequest.
        The type of phone number (eg us-domestic, toll-free, etc), to determine which third-party api(s) to use for the order request.

        :return: The phone_number_type of this NumberOrderRequest.
        :rtype: str
        """
        return self._phone_number_type

    @phone_number_type.setter
    def phone_number_type(self, phone_number_type):
        """
        Sets the phone_number_type of this NumberOrderRequest.
        The type of phone number (eg us-domestic, toll-free, etc), to determine which third-party api(s) to use for the order request.

        :param phone_number_type: The phone_number_type of this NumberOrderRequest.
        :type: str
        """
        allowed_values = ["TOLL_FREE", "CN_DOMESTIC", "US_DOMESTIC", "US_TOLLFREE", "XA_TOLLFREE", "XB_TOLLFREE", "XC_TOLLFREE", "AG_DID", "AI_DID", "BB_DID", "BM_DID", "BS_DID", "CA_DID", "DM_DID", "DO_DID", "GD_DID", "JM_DID", "KN_DID", "KY_DID", "KZ_DID", "LC_DID", "MP_DID", "MS_DID", "RU_DID", "TC_DID", "TT_DID", "US_DID", "VC_DID", "VG_DID", "AF_DID", "AR_DID", "AT_DID", "AU_DID", "BE_DID", "BR_DID", "CH_DID", "CL_DID", "CN_DID", "CO_DID", "CU_DID", "DE_DID", "DK_DID", "EG_DID", "ES_DID", "FR_DID", "GB_DID", "GR_DID", "HU_DID", "ID_DID", "IN_DID", "IR_DID", "IT_DID", "JP_DID", "KR_DID", "LK_DID", "MM_DID", "MX_DID", "MY_DID", "NL_DID", "NO_DID", "NZ_DID", "PE_DID", "PH_DID", "PK_DID", "PL_DID", "RO_DID", "SE_DID", "SG_DID", "TH_DID", "TR_DID", "VE_DID", "VN_DID", "ZA_DID", "AD_DID", "AE_DID", "AL_DID", "AM_DID", "AO_DID", "AQ_DID", "AW_DID", "AZ_DID", "BA_DID", "BD_DID", "BF_DID", "BG_DID", "BH_DID", "BI_DID", "BJ_DID", "BL_DID", "BN_DID", "BO_DID", "BQ_DID", "BT_DID", "BW_DID", "BY_DID", "BZ_DID", "CD_DID", "CF_DID", "CG_DID", "CI_DID", "CK_DID", "CM_DID", "CR_DID", "CV_DID", "CY_DID", "CZ_DID", "DJ_DID", "DZ_DID", "EC_DID", "EE_DID", "EH_DID", "ER_DID", "ET_DID", "FI_DID", "FJ_DID", "FK_DID", "FM_DID", "FO_DID", "GA_DID", "GE_DID", "GF_DID", "GH_DID", "GI_DID", "GL_DID", "GM_DID", "GN_DID", "GP_DID", "GQ_DID", "GT_DID", "GW_DID", "GY_DID", "HK_DID", "HN_DID", "HR_DID", "HT_DID", "IE_DID", "IL_DID", "IO_DID", "IQ_DID", "IS_DID", "JO_DID", "KE_DID", "KG_DID", "KH_DID", "KI_DID", "KM_DID", "KP_DID", "KW_DID", "LA_DID", "LB_DID", "LI_DID", "LR_DID", "LS_DID", "LT_DID", "LU_DID", "LV_DID", "LY_DID", "MA_DID", "MC_DID", "MD_DID", "ME_DID", "MF_DID", "MG_DID", "MH_DID", "MK_DID", "ML_DID", "MN_DID", "MO_DID", "MQ_DID", "MR_DID", "MT_DID", "MU_DID", "MV_DID", "MW_DID", "MZ_DID", "NA_DID", "NC_DID", "NE_DID", "NF_DID", "NG_DID", "NI_DID", "NP_DID", "NR_DID", "NU_DID", "OM_DID", "PA_DID", "PF_DID", "PG_DID", "PM_DID", "PS_DID", "PT_DID", "PW_DID", "PY_DID", "QA_DID", "RE_DID", "RS_DID", "RW_DID", "SA_DID", "SB_DID", "SC_DID", "SD_DID", "SH_247_DID", "SH_290_DID", "SI_DID", "SK_DID", "SL_DID", "SM_DID", "SN_DID", "SO_DID", "SR_DID", "SS_DID", "ST_DID", "SV_DID", "SY_DID", "SZ_DID", "TD_DID", "TG_DID", "TJ_DID", "TK_DID", "TL_DID", "TM_DID", "TN_DID", "TO_DID", "TV_DID", "TW_DID", "TZ_DID", "UA_DID", "UG_DID", "UY_DID", "UZ_DID", "VU_DID", "WF_DID", "WS_DID", "XG_DID", "XN_DID", "XV_882_DID", "XV_883_DID", "YE_DID", "YT_DID", "ZM_DID", "ZW_DID", "SX_DID"]
        if phone_number_type not in allowed_values:
            raise ValueError(
                "Invalid value for `phone_number_type`, must be one of {0}"
                .format(allowed_values)
            )

        self._phone_number_type = phone_number_type

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

