# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re


class PaymentMethod(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        PaymentMethod - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'type': 'str',
            'provider_name': 'str',
            'token': 'str',
            'card_expiration_date': 'str',
            'card_last_four_digits': 'str',
            'card_type': 'str',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'type': 'type',
            'provider_name': 'providerName',
            'token': 'token',
            'card_expiration_date': 'cardExpirationDate',
            'card_last_four_digits': 'cardLastFourDigits',
            'card_type': 'cardType',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._name = None
        self._type = None
        self._provider_name = None
        self._token = None
        self._card_expiration_date = None
        self._card_last_four_digits = None
        self._card_type = None
        self._self_uri = None

    @property
    def id(self):
        """
        Gets the id of this PaymentMethod.
        The globally unique identifier for the object.

        :return: The id of this PaymentMethod.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this PaymentMethod.
        The globally unique identifier for the object.

        :param id: The id of this PaymentMethod.
        :type: str
        """
        
        self._id = id

    @property
    def name(self):
        """
        Gets the name of this PaymentMethod.


        :return: The name of this PaymentMethod.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this PaymentMethod.


        :param name: The name of this PaymentMethod.
        :type: str
        """
        
        self._name = name

    @property
    def type(self):
        """
        Gets the type of this PaymentMethod.


        :return: The type of this PaymentMethod.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this PaymentMethod.


        :param type: The type of this PaymentMethod.
        :type: str
        """
        allowed_values = ["CARD_TOKEN"]
        if type not in allowed_values:
            raise ValueError(
                "Invalid value for `type`, must be one of {0}"
                .format(allowed_values)
            )

        self._type = type

    @property
    def provider_name(self):
        """
        Gets the provider_name of this PaymentMethod.


        :return: The provider_name of this PaymentMethod.
        :rtype: str
        """
        return self._provider_name

    @provider_name.setter
    def provider_name(self, provider_name):
        """
        Sets the provider_name of this PaymentMethod.


        :param provider_name: The provider_name of this PaymentMethod.
        :type: str
        """
        
        self._provider_name = provider_name

    @property
    def token(self):
        """
        Gets the token of this PaymentMethod.


        :return: The token of this PaymentMethod.
        :rtype: str
        """
        return self._token

    @token.setter
    def token(self, token):
        """
        Sets the token of this PaymentMethod.


        :param token: The token of this PaymentMethod.
        :type: str
        """
        
        self._token = token

    @property
    def card_expiration_date(self):
        """
        Gets the card_expiration_date of this PaymentMethod.
        for payment methods of type CARD_TOKEN, the card's expiration date in the format YYYY-MM.

        :return: The card_expiration_date of this PaymentMethod.
        :rtype: str
        """
        return self._card_expiration_date

    @card_expiration_date.setter
    def card_expiration_date(self, card_expiration_date):
        """
        Sets the card_expiration_date of this PaymentMethod.
        for payment methods of type CARD_TOKEN, the card's expiration date in the format YYYY-MM.

        :param card_expiration_date: The card_expiration_date of this PaymentMethod.
        :type: str
        """
        
        self._card_expiration_date = card_expiration_date

    @property
    def card_last_four_digits(self):
        """
        Gets the card_last_four_digits of this PaymentMethod.


        :return: The card_last_four_digits of this PaymentMethod.
        :rtype: str
        """
        return self._card_last_four_digits

    @card_last_four_digits.setter
    def card_last_four_digits(self, card_last_four_digits):
        """
        Sets the card_last_four_digits of this PaymentMethod.


        :param card_last_four_digits: The card_last_four_digits of this PaymentMethod.
        :type: str
        """
        
        self._card_last_four_digits = card_last_four_digits

    @property
    def card_type(self):
        """
        Gets the card_type of this PaymentMethod.
        for payment methods of type CARD_TOKEN, the type of credit or debit card

        :return: The card_type of this PaymentMethod.
        :rtype: str
        """
        return self._card_type

    @card_type.setter
    def card_type(self, card_type):
        """
        Sets the card_type of this PaymentMethod.
        for payment methods of type CARD_TOKEN, the type of credit or debit card

        :param card_type: The card_type of this PaymentMethod.
        :type: str
        """
        allowed_values = ["Visa", "MasterCard", "Discover", "American Express"]
        if card_type not in allowed_values:
            raise ValueError(
                "Invalid value for `card_type`, must be one of {0}"
                .format(allowed_values)
            )

        self._card_type = card_type

    @property
    def self_uri(self):
        """
        Gets the self_uri of this PaymentMethod.
        The URI for this object

        :return: The self_uri of this PaymentMethod.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri):
        """
        Sets the self_uri of this PaymentMethod.
        The URI for this object

        :param self_uri: The self_uri of this PaymentMethod.
        :type: str
        """
        
        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

