# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re


class PortBillingAddress(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        PortBillingAddress - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'street_address': 'str',
            'city_province': 'str',
            'state': 'str',
            'zip_postal': 'str',
            'country': 'str'
        }

        self.attribute_map = {
            'street_address': 'streetAddress',
            'city_province': 'cityProvince',
            'state': 'state',
            'zip_postal': 'zipPostal',
            'country': 'country'
        }

        self._street_address = None
        self._city_province = None
        self._state = None
        self._zip_postal = None
        self._country = None

    @property
    def street_address(self):
        """
        Gets the street_address of this PortBillingAddress.


        :return: The street_address of this PortBillingAddress.
        :rtype: str
        """
        return self._street_address

    @street_address.setter
    def street_address(self, street_address):
        """
        Sets the street_address of this PortBillingAddress.


        :param street_address: The street_address of this PortBillingAddress.
        :type: str
        """
        
        self._street_address = street_address

    @property
    def city_province(self):
        """
        Gets the city_province of this PortBillingAddress.


        :return: The city_province of this PortBillingAddress.
        :rtype: str
        """
        return self._city_province

    @city_province.setter
    def city_province(self, city_province):
        """
        Sets the city_province of this PortBillingAddress.


        :param city_province: The city_province of this PortBillingAddress.
        :type: str
        """
        
        self._city_province = city_province

    @property
    def state(self):
        """
        Gets the state of this PortBillingAddress.


        :return: The state of this PortBillingAddress.
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state):
        """
        Sets the state of this PortBillingAddress.


        :param state: The state of this PortBillingAddress.
        :type: str
        """
        
        self._state = state

    @property
    def zip_postal(self):
        """
        Gets the zip_postal of this PortBillingAddress.


        :return: The zip_postal of this PortBillingAddress.
        :rtype: str
        """
        return self._zip_postal

    @zip_postal.setter
    def zip_postal(self, zip_postal):
        """
        Sets the zip_postal of this PortBillingAddress.


        :param zip_postal: The zip_postal of this PortBillingAddress.
        :type: str
        """
        
        self._zip_postal = zip_postal

    @property
    def country(self):
        """
        Gets the country of this PortBillingAddress.


        :return: The country of this PortBillingAddress.
        :rtype: str
        """
        return self._country

    @country.setter
    def country(self, country):
        """
        Sets the country of this PortBillingAddress.


        :param country: The country of this PortBillingAddress.
        :type: str
        """
        
        self._country = country

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

