# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re


class PropertyIndexRequest(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        PropertyIndexRequest - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'session_id': 'str',
            'timestamp': 'int',
            'properties': 'list[AnalyticsProperty]'
        }

        self.attribute_map = {
            'session_id': 'sessionId',
            'timestamp': 'timestamp',
            'properties': 'properties'
        }

        self._session_id = None
        self._timestamp = None
        self._properties = None

    @property
    def session_id(self):
        """
        Gets the session_id of this PropertyIndexRequest.
        Attach properties to a segment in the indicated session. Also requires a timestamp.

        :return: The session_id of this PropertyIndexRequest.
        :rtype: str
        """
        return self._session_id

    @session_id.setter
    def session_id(self, session_id):
        """
        Sets the session_id of this PropertyIndexRequest.
        Attach properties to a segment in the indicated session. Also requires a timestamp.

        :param session_id: The session_id of this PropertyIndexRequest.
        :type: str
        """
        
        self._session_id = session_id

    @property
    def timestamp(self):
        """
        Gets the timestamp of this PropertyIndexRequest.
        Attach properties to a segment covering a specific point in time. Also requries a sessionId.

        :return: The timestamp of this PropertyIndexRequest.
        :rtype: int
        """
        return self._timestamp

    @timestamp.setter
    def timestamp(self, timestamp):
        """
        Sets the timestamp of this PropertyIndexRequest.
        Attach properties to a segment covering a specific point in time. Also requries a sessionId.

        :param timestamp: The timestamp of this PropertyIndexRequest.
        :type: int
        """
        
        self._timestamp = timestamp

    @property
    def properties(self):
        """
        Gets the properties of this PropertyIndexRequest.
        The list of properties to index

        :return: The properties of this PropertyIndexRequest.
        :rtype: list[AnalyticsProperty]
        """
        return self._properties

    @properties.setter
    def properties(self, properties):
        """
        Sets the properties of this PropertyIndexRequest.
        The list of properties to index

        :param properties: The properties of this PropertyIndexRequest.
        :type: list[AnalyticsProperty]
        """
        
        self._properties = properties

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

