# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re


class Publication(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        Publication - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'date_created': 'datetime',
            'date_modified': 'datetime',
            'tweet_text': 'str',
            'raw_tweet_text': 'str',
            'approved': 'bool',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'date_created': 'dateCreated',
            'date_modified': 'dateModified',
            'tweet_text': 'tweetText',
            'raw_tweet_text': 'rawTweetText',
            'approved': 'approved',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._name = None
        self._date_created = None
        self._date_modified = None
        self._tweet_text = None
        self._raw_tweet_text = None
        self._approved = False
        self._self_uri = None

    @property
    def id(self):
        """
        Gets the id of this Publication.
        The globally unique identifier for the object.

        :return: The id of this Publication.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this Publication.
        The globally unique identifier for the object.

        :param id: The id of this Publication.
        :type: str
        """
        
        self._id = id

    @property
    def name(self):
        """
        Gets the name of this Publication.


        :return: The name of this Publication.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this Publication.


        :param name: The name of this Publication.
        :type: str
        """
        
        self._name = name

    @property
    def date_created(self):
        """
        Gets the date_created of this Publication.
        Creation date for the entity. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :return: The date_created of this Publication.
        :rtype: datetime
        """
        return self._date_created

    @date_created.setter
    def date_created(self, date_created):
        """
        Sets the date_created of this Publication.
        Creation date for the entity. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :param date_created: The date_created of this Publication.
        :type: datetime
        """
        
        self._date_created = date_created

    @property
    def date_modified(self):
        """
        Gets the date_modified of this Publication.
        Date the entity was last modified. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :return: The date_modified of this Publication.
        :rtype: datetime
        """
        return self._date_modified

    @date_modified.setter
    def date_modified(self, date_modified):
        """
        Sets the date_modified of this Publication.
        Date the entity was last modified. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :param date_modified: The date_modified of this Publication.
        :type: datetime
        """
        
        self._date_modified = date_modified

    @property
    def tweet_text(self):
        """
        Gets the tweet_text of this Publication.
        The text of the tweet.

        :return: The tweet_text of this Publication.
        :rtype: str
        """
        return self._tweet_text

    @tweet_text.setter
    def tweet_text(self, tweet_text):
        """
        Sets the tweet_text of this Publication.
        The text of the tweet.

        :param tweet_text: The tweet_text of this Publication.
        :type: str
        """
        
        self._tweet_text = tweet_text

    @property
    def raw_tweet_text(self):
        """
        Gets the raw_tweet_text of this Publication.
        The raw text of the tweet

        :return: The raw_tweet_text of this Publication.
        :rtype: str
        """
        return self._raw_tweet_text

    @raw_tweet_text.setter
    def raw_tweet_text(self, raw_tweet_text):
        """
        Sets the raw_tweet_text of this Publication.
        The raw text of the tweet

        :param raw_tweet_text: The raw_tweet_text of this Publication.
        :type: str
        """
        
        self._raw_tweet_text = raw_tweet_text

    @property
    def approved(self):
        """
        Gets the approved of this Publication.


        :return: The approved of this Publication.
        :rtype: bool
        """
        return self._approved

    @approved.setter
    def approved(self, approved):
        """
        Sets the approved of this Publication.


        :param approved: The approved of this Publication.
        :type: bool
        """
        
        self._approved = approved

    @property
    def self_uri(self):
        """
        Gets the self_uri of this Publication.
        The URI for this object

        :return: The self_uri of this Publication.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri):
        """
        Sets the self_uri of this Publication.
        The URI for this object

        :param self_uri: The self_uri of this Publication.
        :type: str
        """
        
        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

