# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re


class Quote(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        Quote - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'purchase_order': 'str',
            'type': 'str',
            'status': 'str',
            'currency': 'str',
            'created_date': 'datetime',
            'last_updated_date': 'datetime',
            'billing_contact_email': 'str',
            'billing_contact_first_name': 'str',
            'billing_contact_last_name': 'str',
            'billing_contact_phone': 'str',
            'include_voice_charges': 'bool',
            'charges': 'list[QuoteCharge]',
            'edge_control_model': 'str',
            'referral_codes': 'list[str]',
            'discount_codes': 'list[str]',
            'sales_partner_code': 'str',
            'is_annual_prepay': 'bool',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'purchase_order': 'purchaseOrder',
            'type': 'type',
            'status': 'status',
            'currency': 'currency',
            'created_date': 'createdDate',
            'last_updated_date': 'lastUpdatedDate',
            'billing_contact_email': 'billingContactEmail',
            'billing_contact_first_name': 'billingContactFirstName',
            'billing_contact_last_name': 'billingContactLastName',
            'billing_contact_phone': 'billingContactPhone',
            'include_voice_charges': 'includeVoiceCharges',
            'charges': 'charges',
            'edge_control_model': 'edgeControlModel',
            'referral_codes': 'referralCodes',
            'discount_codes': 'discountCodes',
            'sales_partner_code': 'salesPartnerCode',
            'is_annual_prepay': 'isAnnualPrepay',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._name = None
        self._purchase_order = None
        self._type = None
        self._status = None
        self._currency = None
        self._created_date = None
        self._last_updated_date = None
        self._billing_contact_email = None
        self._billing_contact_first_name = None
        self._billing_contact_last_name = None
        self._billing_contact_phone = None
        self._include_voice_charges = False
        self._charges = None
        self._edge_control_model = None
        self._referral_codes = None
        self._discount_codes = None
        self._sales_partner_code = None
        self._is_annual_prepay = False
        self._self_uri = None

    @property
    def id(self):
        """
        Gets the id of this Quote.
        The globally unique identifier for the object.

        :return: The id of this Quote.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this Quote.
        The globally unique identifier for the object.

        :param id: The id of this Quote.
        :type: str
        """
        
        self._id = id

    @property
    def name(self):
        """
        Gets the name of this Quote.


        :return: The name of this Quote.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this Quote.


        :param name: The name of this Quote.
        :type: str
        """
        
        self._name = name

    @property
    def purchase_order(self):
        """
        Gets the purchase_order of this Quote.


        :return: The purchase_order of this Quote.
        :rtype: str
        """
        return self._purchase_order

    @purchase_order.setter
    def purchase_order(self, purchase_order):
        """
        Sets the purchase_order of this Quote.


        :param purchase_order: The purchase_order of this Quote.
        :type: str
        """
        
        self._purchase_order = purchase_order

    @property
    def type(self):
        """
        Gets the type of this Quote.


        :return: The type of this Quote.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this Quote.


        :param type: The type of this Quote.
        :type: str
        """
        allowed_values = ["NEW_SUBSCRIPTION", "AMENDMENT"]
        if type not in allowed_values:
            raise ValueError(
                "Invalid value for `type`, must be one of {0}"
                .format(allowed_values)
            )

        self._type = type

    @property
    def status(self):
        """
        Gets the status of this Quote.


        :return: The status of this Quote.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """
        Sets the status of this Quote.


        :param status: The status of this Quote.
        :type: str
        """
        allowed_values = ["IN_PROGRESS", "SUBMITTED", "FROZEN"]
        if status not in allowed_values:
            raise ValueError(
                "Invalid value for `status`, must be one of {0}"
                .format(allowed_values)
            )

        self._status = status

    @property
    def currency(self):
        """
        Gets the currency of this Quote.


        :return: The currency of this Quote.
        :rtype: str
        """
        return self._currency

    @currency.setter
    def currency(self, currency):
        """
        Sets the currency of this Quote.


        :param currency: The currency of this Quote.
        :type: str
        """
        
        self._currency = currency

    @property
    def created_date(self):
        """
        Gets the created_date of this Quote.
        Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :return: The created_date of this Quote.
        :rtype: datetime
        """
        return self._created_date

    @created_date.setter
    def created_date(self, created_date):
        """
        Sets the created_date of this Quote.
        Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :param created_date: The created_date of this Quote.
        :type: datetime
        """
        
        self._created_date = created_date

    @property
    def last_updated_date(self):
        """
        Gets the last_updated_date of this Quote.
        Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :return: The last_updated_date of this Quote.
        :rtype: datetime
        """
        return self._last_updated_date

    @last_updated_date.setter
    def last_updated_date(self, last_updated_date):
        """
        Sets the last_updated_date of this Quote.
        Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :param last_updated_date: The last_updated_date of this Quote.
        :type: datetime
        """
        
        self._last_updated_date = last_updated_date

    @property
    def billing_contact_email(self):
        """
        Gets the billing_contact_email of this Quote.


        :return: The billing_contact_email of this Quote.
        :rtype: str
        """
        return self._billing_contact_email

    @billing_contact_email.setter
    def billing_contact_email(self, billing_contact_email):
        """
        Sets the billing_contact_email of this Quote.


        :param billing_contact_email: The billing_contact_email of this Quote.
        :type: str
        """
        
        self._billing_contact_email = billing_contact_email

    @property
    def billing_contact_first_name(self):
        """
        Gets the billing_contact_first_name of this Quote.


        :return: The billing_contact_first_name of this Quote.
        :rtype: str
        """
        return self._billing_contact_first_name

    @billing_contact_first_name.setter
    def billing_contact_first_name(self, billing_contact_first_name):
        """
        Sets the billing_contact_first_name of this Quote.


        :param billing_contact_first_name: The billing_contact_first_name of this Quote.
        :type: str
        """
        
        self._billing_contact_first_name = billing_contact_first_name

    @property
    def billing_contact_last_name(self):
        """
        Gets the billing_contact_last_name of this Quote.


        :return: The billing_contact_last_name of this Quote.
        :rtype: str
        """
        return self._billing_contact_last_name

    @billing_contact_last_name.setter
    def billing_contact_last_name(self, billing_contact_last_name):
        """
        Sets the billing_contact_last_name of this Quote.


        :param billing_contact_last_name: The billing_contact_last_name of this Quote.
        :type: str
        """
        
        self._billing_contact_last_name = billing_contact_last_name

    @property
    def billing_contact_phone(self):
        """
        Gets the billing_contact_phone of this Quote.


        :return: The billing_contact_phone of this Quote.
        :rtype: str
        """
        return self._billing_contact_phone

    @billing_contact_phone.setter
    def billing_contact_phone(self, billing_contact_phone):
        """
        Sets the billing_contact_phone of this Quote.


        :param billing_contact_phone: The billing_contact_phone of this Quote.
        :type: str
        """
        
        self._billing_contact_phone = billing_contact_phone

    @property
    def include_voice_charges(self):
        """
        Gets the include_voice_charges of this Quote.


        :return: The include_voice_charges of this Quote.
        :rtype: bool
        """
        return self._include_voice_charges

    @include_voice_charges.setter
    def include_voice_charges(self, include_voice_charges):
        """
        Sets the include_voice_charges of this Quote.


        :param include_voice_charges: The include_voice_charges of this Quote.
        :type: bool
        """
        
        self._include_voice_charges = include_voice_charges

    @property
    def charges(self):
        """
        Gets the charges of this Quote.


        :return: The charges of this Quote.
        :rtype: list[QuoteCharge]
        """
        return self._charges

    @charges.setter
    def charges(self, charges):
        """
        Sets the charges of this Quote.


        :param charges: The charges of this Quote.
        :type: list[QuoteCharge]
        """
        
        self._charges = charges

    @property
    def edge_control_model(self):
        """
        Gets the edge_control_model of this Quote.


        :return: The edge_control_model of this Quote.
        :rtype: str
        """
        return self._edge_control_model

    @edge_control_model.setter
    def edge_control_model(self, edge_control_model):
        """
        Sets the edge_control_model of this Quote.


        :param edge_control_model: The edge_control_model of this Quote.
        :type: str
        """
        
        self._edge_control_model = edge_control_model

    @property
    def referral_codes(self):
        """
        Gets the referral_codes of this Quote.


        :return: The referral_codes of this Quote.
        :rtype: list[str]
        """
        return self._referral_codes

    @referral_codes.setter
    def referral_codes(self, referral_codes):
        """
        Sets the referral_codes of this Quote.


        :param referral_codes: The referral_codes of this Quote.
        :type: list[str]
        """
        
        self._referral_codes = referral_codes

    @property
    def discount_codes(self):
        """
        Gets the discount_codes of this Quote.


        :return: The discount_codes of this Quote.
        :rtype: list[str]
        """
        return self._discount_codes

    @discount_codes.setter
    def discount_codes(self, discount_codes):
        """
        Sets the discount_codes of this Quote.


        :param discount_codes: The discount_codes of this Quote.
        :type: list[str]
        """
        
        self._discount_codes = discount_codes

    @property
    def sales_partner_code(self):
        """
        Gets the sales_partner_code of this Quote.


        :return: The sales_partner_code of this Quote.
        :rtype: str
        """
        return self._sales_partner_code

    @sales_partner_code.setter
    def sales_partner_code(self, sales_partner_code):
        """
        Sets the sales_partner_code of this Quote.


        :param sales_partner_code: The sales_partner_code of this Quote.
        :type: str
        """
        
        self._sales_partner_code = sales_partner_code

    @property
    def is_annual_prepay(self):
        """
        Gets the is_annual_prepay of this Quote.


        :return: The is_annual_prepay of this Quote.
        :rtype: bool
        """
        return self._is_annual_prepay

    @is_annual_prepay.setter
    def is_annual_prepay(self, is_annual_prepay):
        """
        Sets the is_annual_prepay of this Quote.


        :param is_annual_prepay: The is_annual_prepay of this Quote.
        :type: bool
        """
        
        self._is_annual_prepay = is_annual_prepay

    @property
    def self_uri(self):
        """
        Gets the self_uri of this Quote.
        The URI for this object

        :return: The self_uri of this Quote.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri):
        """
        Sets the self_uri of this Quote.
        The URI for this object

        :param self_uri: The self_uri of this Quote.
        :type: str
        """
        
        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

