# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re


class QuoteCharge(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        QuoteCharge - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'sku': 'str',
            'name': 'str',
            'charge_type': 'str',
            'quantity': 'int',
            'list_total': 'str',
            'total': 'str',
            'list_price_display': 'str',
            'discount': 'str',
            'effective_price': 'str',
            'product_shippable': 'bool',
            'shipping_address': 'BillingAddress',
            'for_related_part': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'sku': 'sku',
            'name': 'name',
            'charge_type': 'chargeType',
            'quantity': 'quantity',
            'list_total': 'listTotal',
            'total': 'total',
            'list_price_display': 'listPriceDisplay',
            'discount': 'discount',
            'effective_price': 'effectivePrice',
            'product_shippable': 'productShippable',
            'shipping_address': 'shippingAddress',
            'for_related_part': 'forRelatedPart'
        }

        self._id = None
        self._sku = None
        self._name = None
        self._charge_type = None
        self._quantity = None
        self._list_total = None
        self._total = None
        self._list_price_display = None
        self._discount = None
        self._effective_price = None
        self._product_shippable = False
        self._shipping_address = None
        self._for_related_part = None

    @property
    def id(self):
        """
        Gets the id of this QuoteCharge.
        The quote charge Id.

        :return: The id of this QuoteCharge.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this QuoteCharge.
        The quote charge Id.

        :param id: The id of this QuoteCharge.
        :type: str
        """
        
        self._id = id

    @property
    def sku(self):
        """
        Gets the sku of this QuoteCharge.
        The quote charge SKU.

        :return: The sku of this QuoteCharge.
        :rtype: str
        """
        return self._sku

    @sku.setter
    def sku(self, sku):
        """
        Sets the sku of this QuoteCharge.
        The quote charge SKU.

        :param sku: The sku of this QuoteCharge.
        :type: str
        """
        
        self._sku = sku

    @property
    def name(self):
        """
        Gets the name of this QuoteCharge.
        The quote charge name.

        :return: The name of this QuoteCharge.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this QuoteCharge.
        The quote charge name.

        :param name: The name of this QuoteCharge.
        :type: str
        """
        
        self._name = name

    @property
    def charge_type(self):
        """
        Gets the charge_type of this QuoteCharge.
        The quote charge type.

        :return: The charge_type of this QuoteCharge.
        :rtype: str
        """
        return self._charge_type

    @charge_type.setter
    def charge_type(self, charge_type):
        """
        Sets the charge_type of this QuoteCharge.
        The quote charge type.

        :param charge_type: The charge_type of this QuoteCharge.
        :type: str
        """
        
        self._charge_type = charge_type

    @property
    def quantity(self):
        """
        Gets the quantity of this QuoteCharge.
        The quote charge quantity.

        :return: The quantity of this QuoteCharge.
        :rtype: int
        """
        return self._quantity

    @quantity.setter
    def quantity(self, quantity):
        """
        Sets the quantity of this QuoteCharge.
        The quote charge quantity.

        :param quantity: The quantity of this QuoteCharge.
        :type: int
        """
        
        self._quantity = quantity

    @property
    def list_total(self):
        """
        Gets the list_total of this QuoteCharge.
        The quote charge total price before discounts.

        :return: The list_total of this QuoteCharge.
        :rtype: str
        """
        return self._list_total

    @list_total.setter
    def list_total(self, list_total):
        """
        Sets the list_total of this QuoteCharge.
        The quote charge total price before discounts.

        :param list_total: The list_total of this QuoteCharge.
        :type: str
        """
        
        self._list_total = list_total

    @property
    def total(self):
        """
        Gets the total of this QuoteCharge.
        The quote charge total price after discounts.

        :return: The total of this QuoteCharge.
        :rtype: str
        """
        return self._total

    @total.setter
    def total(self, total):
        """
        Sets the total of this QuoteCharge.
        The quote charge total price after discounts.

        :param total: The total of this QuoteCharge.
        :type: str
        """
        
        self._total = total

    @property
    def list_price_display(self):
        """
        Gets the list_price_display of this QuoteCharge.
        The quote charge list price before discounts.

        :return: The list_price_display of this QuoteCharge.
        :rtype: str
        """
        return self._list_price_display

    @list_price_display.setter
    def list_price_display(self, list_price_display):
        """
        Sets the list_price_display of this QuoteCharge.
        The quote charge list price before discounts.

        :param list_price_display: The list_price_display of this QuoteCharge.
        :type: str
        """
        
        self._list_price_display = list_price_display

    @property
    def discount(self):
        """
        Gets the discount of this QuoteCharge.
        The quote charge discount percent.

        :return: The discount of this QuoteCharge.
        :rtype: str
        """
        return self._discount

    @discount.setter
    def discount(self, discount):
        """
        Sets the discount of this QuoteCharge.
        The quote charge discount percent.

        :param discount: The discount of this QuoteCharge.
        :type: str
        """
        
        self._discount = discount

    @property
    def effective_price(self):
        """
        Gets the effective_price of this QuoteCharge.
        The quote charge list price after discounts.

        :return: The effective_price of this QuoteCharge.
        :rtype: str
        """
        return self._effective_price

    @effective_price.setter
    def effective_price(self, effective_price):
        """
        Sets the effective_price of this QuoteCharge.
        The quote charge list price after discounts.

        :param effective_price: The effective_price of this QuoteCharge.
        :type: str
        """
        
        self._effective_price = effective_price

    @property
    def product_shippable(self):
        """
        Gets the product_shippable of this QuoteCharge.
        Indicates whether the product can be shipped.

        :return: The product_shippable of this QuoteCharge.
        :rtype: bool
        """
        return self._product_shippable

    @product_shippable.setter
    def product_shippable(self, product_shippable):
        """
        Sets the product_shippable of this QuoteCharge.
        Indicates whether the product can be shipped.

        :param product_shippable: The product_shippable of this QuoteCharge.
        :type: bool
        """
        
        self._product_shippable = product_shippable

    @property
    def shipping_address(self):
        """
        Gets the shipping_address of this QuoteCharge.
        The quote shipping address.

        :return: The shipping_address of this QuoteCharge.
        :rtype: BillingAddress
        """
        return self._shipping_address

    @shipping_address.setter
    def shipping_address(self, shipping_address):
        """
        Sets the shipping_address of this QuoteCharge.
        The quote shipping address.

        :param shipping_address: The shipping_address of this QuoteCharge.
        :type: BillingAddress
        """
        
        self._shipping_address = shipping_address

    @property
    def for_related_part(self):
        """
        Gets the for_related_part of this QuoteCharge.
        The part number of a part related to the quote charge.

        :return: The for_related_part of this QuoteCharge.
        :rtype: str
        """
        return self._for_related_part

    @for_related_part.setter
    def for_related_part(self, for_related_part):
        """
        Sets the for_related_part of this QuoteCharge.
        The part number of a part related to the quote charge.

        :param for_related_part: The for_related_part of this QuoteCharge.
        :type: str
        """
        
        self._for_related_part = for_related_part

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

