# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re


class ReportRequest(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        ReportRequest - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'page_number': 'int',
            'page_size': 'int',
            'facet_requests': 'list[FacetRequest]',
            'sort': 'list[SortField]',
            'filters': 'list[FilterItem]',
            'group_by': 'list[str]'
        }

        self.attribute_map = {
            'page_number': 'pageNumber',
            'page_size': 'pageSize',
            'facet_requests': 'facetRequests',
            'sort': 'sort',
            'filters': 'filters',
            'group_by': 'groupBy'
        }

        self._page_number = None
        self._page_size = None
        self._facet_requests = None
        self._sort = None
        self._filters = None
        self._group_by = None

    @property
    def page_number(self):
        """
        Gets the page_number of this ReportRequest.
        The pageNumber to get results from (EG If there are 100 results with a pageSize of 10 and pageNumber is 3 then 10 results will be returned starting with index #31

        :return: The page_number of this ReportRequest.
        :rtype: int
        """
        return self._page_number

    @page_number.setter
    def page_number(self, page_number):
        """
        Sets the page_number of this ReportRequest.
        The pageNumber to get results from (EG If there are 100 results with a pageSize of 10 and pageNumber is 3 then 10 results will be returned starting with index #31

        :param page_number: The page_number of this ReportRequest.
        :type: int
        """
        
        self._page_number = page_number

    @property
    def page_size(self):
        """
        Gets the page_size of this ReportRequest.
        Number of entries to return/calculate per page.

        :return: The page_size of this ReportRequest.
        :rtype: int
        """
        return self._page_size

    @page_size.setter
    def page_size(self, page_size):
        """
        Sets the page_size of this ReportRequest.
        Number of entries to return/calculate per page.

        :param page_size: The page_size of this ReportRequest.
        :type: int
        """
        
        self._page_size = page_size

    @property
    def facet_requests(self):
        """
        Gets the facet_requests of this ReportRequest.
        List of facet requests to generate summary views from the report result set (if any)

        :return: The facet_requests of this ReportRequest.
        :rtype: list[FacetRequest]
        """
        return self._facet_requests

    @facet_requests.setter
    def facet_requests(self, facet_requests):
        """
        Sets the facet_requests of this ReportRequest.
        List of facet requests to generate summary views from the report result set (if any)

        :param facet_requests: The facet_requests of this ReportRequest.
        :type: list[FacetRequest]
        """
        
        self._facet_requests = facet_requests

    @property
    def sort(self):
        """
        Gets the sort of this ReportRequest.
        sort the results on a field(s)

        :return: The sort of this ReportRequest.
        :rtype: list[SortField]
        """
        return self._sort

    @sort.setter
    def sort(self, sort):
        """
        Sets the sort of this ReportRequest.
        sort the results on a field(s)

        :param sort: The sort of this ReportRequest.
        :type: list[SortField]
        """
        
        self._sort = sort

    @property
    def filters(self):
        """
        Gets the filters of this ReportRequest.
        You can also restrict the request to particular field values and ranges

        :return: The filters of this ReportRequest.
        :rtype: list[FilterItem]
        """
        return self._filters

    @filters.setter
    def filters(self, filters):
        """
        Sets the filters of this ReportRequest.
        You can also restrict the request to particular field values and ranges

        :param filters: The filters of this ReportRequest.
        :type: list[FilterItem]
        """
        
        self._filters = filters

    @property
    def group_by(self):
        """
        Gets the group_by of this ReportRequest.


        :return: The group_by of this ReportRequest.
        :rtype: list[str]
        """
        return self._group_by

    @group_by.setter
    def group_by(self, group_by):
        """
        Sets the group_by of this ReportRequest.


        :param group_by: The group_by of this ReportRequest.
        :type: list[str]
        """
        
        self._group_by = group_by

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

