# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re


class Scene(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        Scene - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'scene_group': 'SceneGroup',
            'assets': 'list[Asset]',
            'thumbnail': 'Thumbnail',
            'description': 'str',
            'waypoints': 'list[Waypoint]',
            'default_orientation_y': 'float',
            'type': 'str',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'scene_group': 'sceneGroup',
            'assets': 'assets',
            'thumbnail': 'thumbnail',
            'description': 'description',
            'waypoints': 'waypoints',
            'default_orientation_y': 'defaultOrientationY',
            'type': 'type',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._name = None
        self._scene_group = None
        self._assets = None
        self._thumbnail = None
        self._description = None
        self._waypoints = None
        self._default_orientation_y = None
        self._type = None
        self._self_uri = None

    @property
    def id(self):
        """
        Gets the id of this Scene.
        The globally unique identifier for the object.

        :return: The id of this Scene.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this Scene.
        The globally unique identifier for the object.

        :param id: The id of this Scene.
        :type: str
        """
        
        self._id = id

    @property
    def name(self):
        """
        Gets the name of this Scene.


        :return: The name of this Scene.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this Scene.


        :param name: The name of this Scene.
        :type: str
        """
        
        self._name = name

    @property
    def scene_group(self):
        """
        Gets the scene_group of this Scene.


        :return: The scene_group of this Scene.
        :rtype: SceneGroup
        """
        return self._scene_group

    @scene_group.setter
    def scene_group(self, scene_group):
        """
        Sets the scene_group of this Scene.


        :param scene_group: The scene_group of this Scene.
        :type: SceneGroup
        """
        
        self._scene_group = scene_group

    @property
    def assets(self):
        """
        Gets the assets of this Scene.


        :return: The assets of this Scene.
        :rtype: list[Asset]
        """
        return self._assets

    @assets.setter
    def assets(self, assets):
        """
        Sets the assets of this Scene.


        :param assets: The assets of this Scene.
        :type: list[Asset]
        """
        
        self._assets = assets

    @property
    def thumbnail(self):
        """
        Gets the thumbnail of this Scene.


        :return: The thumbnail of this Scene.
        :rtype: Thumbnail
        """
        return self._thumbnail

    @thumbnail.setter
    def thumbnail(self, thumbnail):
        """
        Sets the thumbnail of this Scene.


        :param thumbnail: The thumbnail of this Scene.
        :type: Thumbnail
        """
        
        self._thumbnail = thumbnail

    @property
    def description(self):
        """
        Gets the description of this Scene.


        :return: The description of this Scene.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this Scene.


        :param description: The description of this Scene.
        :type: str
        """
        
        self._description = description

    @property
    def waypoints(self):
        """
        Gets the waypoints of this Scene.


        :return: The waypoints of this Scene.
        :rtype: list[Waypoint]
        """
        return self._waypoints

    @waypoints.setter
    def waypoints(self, waypoints):
        """
        Sets the waypoints of this Scene.


        :param waypoints: The waypoints of this Scene.
        :type: list[Waypoint]
        """
        
        self._waypoints = waypoints

    @property
    def default_orientation_y(self):
        """
        Gets the default_orientation_y of this Scene.


        :return: The default_orientation_y of this Scene.
        :rtype: float
        """
        return self._default_orientation_y

    @default_orientation_y.setter
    def default_orientation_y(self, default_orientation_y):
        """
        Sets the default_orientation_y of this Scene.


        :param default_orientation_y: The default_orientation_y of this Scene.
        :type: float
        """
        
        self._default_orientation_y = default_orientation_y

    @property
    def type(self):
        """
        Gets the type of this Scene.


        :return: The type of this Scene.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this Scene.


        :param type: The type of this Scene.
        :type: str
        """
        allowed_values = ["PRIMARY", "SECONDARY"]
        if type not in allowed_values:
            raise ValueError(
                "Invalid value for `type`, must be one of {0}"
                .format(allowed_values)
            )

        self._type = type

    @property
    def self_uri(self):
        """
        Gets the self_uri of this Scene.
        The URI for this object

        :return: The self_uri of this Scene.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri):
        """
        Sets the self_uri of this Scene.
        The URI for this object

        :param self_uri: The self_uri of this Scene.
        :type: str
        """
        
        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

